﻿using System;
using System.Collections.Generic;

// use the Sho libraries:
using ShoNS.Array;
using ShoNS.Visualization;
using ShoNS.MathFunc;  // for the RandomDoubleArray method

namespace CSharpExample
{
    class Program
    {
        static void Main(string[] args)
        {
            // Fill in the following line (and uncomment!) if the SHODIR environment variable is not set on the target machine.
            // You should replace c:\MySho to point to the directory containing your copy of Sho (under which there should be
            // a subdirectory, bin, containing ShoArray.dll, MatrixInterf.dll, ShoViz.dll, MathFunc.dll, ArrayT.dll, MKL.dll,
            // and libiomp5md.dll)
            // System.Environment.SetEnvironmentVariable("SHODIR", @"c:\MySho\", System.EnvironmentVariableTarget.Process);

            // Create an array to work with
            DoubleArray x = ArrayRandom.RandomDoubleArray(10, 10);
            x = x * x.T; // multipy by its transpose
            SVD svd = new SVD(x);     // do a singular-value decomposition

            // Create a figure and display a barchart of the log of the singular values
            IFigure f1 = ShoPlotHelper.Figure();
            DoubleArray logVals = ArrayMath.Log(svd.D.Diagonal + 1.0);
            f1.Bar(logVals);

            // Create another figure and add some line plots
            IFigure f2 = ShoPlotHelper.Figure();
            f2.Hold = true; // turn "hold" on so that each call to Plot() adds a new series
            int numrows = svd.V.size0;
            int numcols = svd.V.size1;
            for (int rowIndex = 0; rowIndex < numrows; rowIndex++)
            {
                DoubleArray rowVals = x.GetSlice(rowIndex, rowIndex, 1, 0, numcols - 1, 1); // we use GetSlice to get a row from the matrix
                // Here, we pass in a line specifier to indicate we want a line chart with markers on the datapoints
                f2.Plot(rowVals, ".-"); 
            }

            // Display a datagrid with the raw array values
            IFigure f3 = ShoPlotHelper.Figure(); 
            f3.DGV(x);

            // When the program is finished executing, it stays open until the figure windows
            // are closed. You can programatically close all the Sho figures with the following:
            // ShoPlotHelper.CloseAllFigures();
        }
    }
}
