﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace trajectoryConcatenation
{
    class main
    {
        List<traj>[] driverTraj;               //driver D's Tth trajectory
        static int allDriver = 32670;          //total number of driver
        static int allRoad = 196307;           //total number of road
        double[] roadLength;
        double[] roadSpeed;
        List<Tuple<int, int>>[] roadInvList;   //invert list for each road segments that contains the drivers and trajectories traverse given road segments
        trie realTimeTrie;                     //real time suffix tree, including trajectories and travel time indexing
        trie fstTrie;                          //frequent trajectory pattern suffix tree
        List<traj> testTraj;                   //list for query paths
        tensorDec realTimeTD;                  //object for loading tensor decomposition results
        double[] roadHistoricalTravelTime;     //historical travel time for each road segments
        int testNum;

        // it is a tentative code.
        void run()
        {
            roadLength = new double[allRoad + 1];
            roadSpeed = new double[allRoad + 1];
            loadLengthSpeedforRoad();
            fstTrie = new trie(allRoad, 20);
            loadFST();

            int[, ] monthDayTime = new int[1,3]{{10, 25, 8}};//the size of time slots in our approach is half an hour
            
            for (int iter = 0; iter < 1; iter ++ )
            {
                initialize(monthDayTime[iter, 0], monthDayTime[iter, 1], monthDayTime[iter, 2] * 2 + 1, monthDayTime[iter, 2] * 2 + 2);
            }
        }

        void initialize(int month, int day, int timeSliceSmall, int timeSliceBig)
        {
            Console.WriteLine(month + " " + day + " " + timeSliceSmall + " " + timeSliceBig);

            driverTraj = new List<traj>[allDriver + 1];
            for (int d = 1; d <= allDriver; d++)
            {
                driverTraj[d] = new List<traj>();
            }

            roadInvList = new List<Tuple<int,int>>[allRoad + 1];
            for (int r = 1; r <= allRoad; r++)
            {
                roadInvList[r] = new List<Tuple<int, int>>();
            }

            loadTraj(month, day, timeSliceSmall, timeSliceBig);
            createIndex();
            realTimeTrie = new trie(allRoad, 20);
            testNum = 0;
            getTestTraj();
            realTimeTD = new tensorDec(month, day, timeSliceSmall, timeSliceBig);

            //load Historical Travel Time for each road segment
            roadHistoricalTravelTime = new double[allRoad + 1];
            string filePath = "XXX";
            StreamReader sr = new StreamReader(filePath + month + day + ".txt");
            for (int currentRoad = 1; currentRoad <= allRoad; currentRoad++)
            {
                string line = sr.ReadLine();
                roadHistoricalTravelTime[currentRoad] = Convert.ToDouble(line);
            }
            sr.Close();

            Console.WriteLine("Running OC with Context Aware Tensor Decomposition");
            double[] frequentSubTrajectoryWithTensorTime = frequentSubTrajectoryWithTensor(100);            
        
        }

        // load frequent trajctory patterns and build a suffix-tree for them
        void loadFST()
        { 
            string filePath = "XXX.txt";
            StreamReader sr = new StreamReader(filePath);
            List<int> thisFST;
            Tuple<int, int> uselessTuple = new Tuple<int,int>(0, 0);
            while (!sr.EndOfStream)
            {
                thisFST = new List<int>();
                string line = sr.ReadLine();
                string[] lineData = line.Split(' ');
                for (int l = 0; l < lineData.Length; l++)
                {
                    thisFST.Add( Convert.ToInt32( lineData[l]));
                }

                fstTrie.addTrajForFST(thisFST, uselessTuple);
            }
            sr.Close();
        }

        //load length and speed limit for each road segment
        void loadLengthSpeedforRoad()
        {
           
        }

        //load trajectory of driver Uj at current time slots into driverTraj[Uj], which is a List<traj> object
        void loadTraj(int month, int day, int timeSliceSmall, int timeSliceBig)
        {
           
        }

        //create inverted list for driverTraj
        //roadInvList[Road Ri] is a List<Tuple<int, int>>(d, t) object, which represents Road Ri is traversed by driver d's number t trajectory
        void createIndex()
        {
            for (int d = 1; d <= allDriver; d++)          
                for (int t = 0; t < driverTraj[d].Count; t++)            
                    for (int i = 0; i < driverTraj[d][t].getRoadCount(); i++)
                    {                  
                        int thisRoad = driverTraj[d][t].getRoadbyIndex(i);
                        Tuple<int, int> thisInvList = new Tuple<int,int>(d, t);
                        roadInvList[thisRoad].Add(thisInvList);
                    }
        }

        //create realTime suffix tree and generate test trajectories
        void getTestTraj()
        {
            testNum = 50;  //set number of test traj
            testTraj = new List<traj>();
            for (int d = 1; d <= allDriver; d++)
            {
                for (int t = 0; t < driverTraj[d].Count; t++)
                {
                    Tuple<int, int> driverTrajIndex = new Tuple<int, int>(d, t);
                    realTimeTrie.addTraj(driverTraj[d][t].getRoad(), driverTraj[d][t].time, driverTrajIndex);
                }
            }

            //.....
            //.....generate test trajectories
            //There are several ways to generate test traj. 
            //For instance, 1. synthetic query paths from real-time suffix tree
            //              2. real-world query paths from in the field data
            //              3. .......

        }

        //Running OC with Context Aware Tensor Decomposition
        double[] frequentSubTrajectoryWithTensor(int theta)
        {
            double[] travelTime = new double[testNum];
            for (int test = 0; test < testNum; test++)
            {
                double[] minopt2 = new double[testTraj[test].getRoadCount()]; // tensor
                double[] minoptTime2 = new double[testTraj[test].getRoadCount()];

                for (int endr = 0; endr < testTraj[test].getRoadCount(); endr++)
                {
                    minopt2[endr] = 100000000;
                    int startPoint = (endr - theta + 1) < 0 ? 0 : endr - theta + 1;

                    for (int startr = startPoint; startr <= endr; startr++)
                    {
                        List<int> thisTestTrajRoad = testTraj[test].getRoad();
                        int fstCount = fstTrie.getFrequency(thisTestTrajRoad, startr, endr);
                        List<Tuple<int, int>> realTimeDriverTrajPool = realTimeTrie.getDriverTrajPool(thisTestTrajRoad, startr, endr);

                        int realTimeCount = realTimeDriverTrajPool.Count;
                        if (fstCount > 0)
                        {
                            int tempEndr = endr;

                            while (realTimeCount <= 1 && startr != tempEndr)
                            {
                                tempEndr--;
                                realTimeDriverTrajPool = realTimeTrie.getDriverTrajPool(thisTestTrajRoad, startr, tempEndr);
                                realTimeCount = realTimeDriverTrajPool.Count;
                            }

                            List<double> realTimeTravelTime = realTimeTrie.getTravelTime(thisTestTrajRoad, startr, tempEndr);
                            if (realTimeCount > 0)
                            {
                                List<double> time2 = new List<double>();

                                for (int driverTrajIndex = 0; driverTrajIndex < realTimeDriverTrajPool.Count; driverTrajIndex++)
                                {
                                    double thisTime2 = 0;
                                    traj newTraj = driverTraj[realTimeDriverTrajPool[driverTrajIndex].Item1][realTimeDriverTrajPool[driverTrajIndex].Item2];
                                    thisTime2 += realTimeTravelTime[driverTrajIndex];

                                    for (int roadIndex = tempEndr + 1; roadIndex <= endr; roadIndex++)
                                    {
                                        int thisRoad = testTraj[test].getRoadbyIndex(roadIndex);
                                        double thisValue = 0;
                                        int thisDriver = realTimeDriverTrajPool[driverTrajIndex].Item1;
                                        thisValue = realTimeTD.getElementValue(thisRoad, thisDriver);
                                        if (thisValue == 0)
                                        {
                                            thisValue = roadLength[thisRoad] / roadSpeed[thisRoad];
                                        }
                                        thisTime2 += thisValue;
                                    }
                                    time2.Add(thisTime2);
                                }

                                if (time2.Count > 0)
                                {
                                    double var = getG(time2);
                                    if (startr == 0)
                                    {
                                        if (var < minopt2[endr])
                                        {
                                            minopt2[endr] = var;
                                            minoptTime2[endr] = time2.ToArray().Average();
                                        }
                                    }
                                    else
                                    {
                                        if (minopt2[startr - 1] + var < minopt2[endr])
                                        {
                                            minopt2[endr] = minopt2[startr - 1] + var;
                                            minoptTime2[endr] = minoptTime2[startr - 1] + time2.ToArray().Average();
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (minopt2[endr] == 100000000)
                    {
                        //if this sub-path is not frequent trajectory pattern, we can employ different strategies
                        int thisRoad = testTraj[test].getRoadbyIndex(endr);

                        double thisValue = roadHistoricalTravelTime[thisRoad];
                        if (thisValue == 0)
                        {
                            thisValue = roadLength[thisRoad] / roadSpeed[thisRoad];
                        }
                        if (endr == 0)
                        {
                            minopt2[endr] = 0;
                            minoptTime2[endr] = thisValue;
                        }
                        else
                        {
                            minopt2[endr] = minopt2[endr - 1];
                            minoptTime2[endr] = minoptTime2[endr - 1] + thisValue;
                        }
                    }
                }
                travelTime[test] = minoptTime2[testTraj[test].getRoadCount() - 1];
            }
            return travelTime;
        }

        double getG(List<double> _arr)
        {
            double[] arr = _arr.ToArray();
            double result = 0;
            double mean = arr.Average();

            for (int i = 0; i < arr.Length; i++)
            {
                result = result + (arr[i] - mean) * (arr[i] - mean);
            }

            result /= arr.Length;
            return result;
        }
    }
}
