// Copyright (C) 2011 Microsoft Research
// CM Wintersteiger, 2011

#ifndef _DESAT_H_
#define _DESAT_H_

#include <time.h>
#include <omp.h>

#include <vector>

#include "satsolver.h"
#include "decomposition.h"
#include "translation.h"
#include "interpolation_mode.h"
#include "interpolator.h"
#include "partition.h"

class DeSAT : public SATSolver
{
public:
  DeSAT(ExpressionManager &m, unsigned partitions); // uses all available cores
  DeSAT(ExpressionManager &m, unsigned partitions, unsigned cores);
  virtual ~DeSAT(void);

  clock_t globalTime;
  clock_t partitionsTime;
  clock_t importTime;
  clock_t lastIterationTime;

  virtual bool addClause(const std::vector<signed> &literals);
  virtual bool addUnit(signed l);
  virtual void setVariableMax(unsigned n);
  virtual void setClauseMax(unsigned n);

  virtual signed addVar(void);
  virtual unsigned numClauses(void) const;
  virtual unsigned numVars(void) const;

  virtual bool solve(void);
  virtual bool solve(const std::vector<signed> &assumptions);

  inline virtual ModelValue get(signed l) const;

  virtual Expression getInterpolant(const std::vector<signed> &A);
  virtual bool addConstraint(CExpression &e);
  virtual signed addExtension(CExpression &e);

  virtual Expression getModel(void) const;
  
  virtual void setVerbose(int v);

  void setInterpolator(InterpolationMode i);  
  
public:
  unsigned interpolants_imported;
  unsigned rounds;
  unsigned solutions_imported;
  unsigned all_sat_found;

protected:
  unsigned n_partitions;
  unsigned n_cores;
  unsigned maxVar;

  bool early_stop;
  
  InterpolationMode interpolationMode;  
  
  Decomposition *d;
  SATSolver *globalSolver;
  std::vector<Partition*> partitions;
  SharedVariables sharedVariables;  

  void init(unsigned partitions, unsigned cs);
  void showDistribution(void) const;

  std::vector<signed> assumptions;
  std::vector<Expression> interpolants;
  std::vector<signed> trail;
  std::vector<bool> reasons;
  std::vector<signed> temp;    
  
  bool solveGlobals(void);
  bool solvePartitions(void);
  bool solvePartition(int tid);
  bool importInterpolants(void);
  bool findDisagreement(void);

  bool have_error, have_bad_alloc;
  std::exception exception;
  std::bad_alloc ba_exception;
};

#endif