// Copyright (C) 2011 Microsoft Research
// CM Wintersteiger, 2011

#ifndef _DESAT_OLD_H_
#define _DESAT_OLD_H_

#include <vector>

#include <expression.h>

#include "satsolver.h"
#include "decomposition.h"
#include "translation.h"
#include "interpolator.h"
#include "interpolation_mode.h"

class DeSAT_old : public SATSolver
{
public:  
  DeSAT_old(ExpressionManager &m); // uses all available cores
  DeSAT_old(ExpressionManager &m, unsigned cores);
  virtual ~DeSAT_old(void);

  clock_t globalTime;
  clock_t partitionsTime;
  clock_t importTime;

  virtual bool addClause(const std::vector<signed> &literals);
  virtual bool addUnit(signed l);
  virtual void setVariableMax(unsigned n);
  virtual void setClauseMax(unsigned n);

  virtual signed addVar(void);
  virtual unsigned numClauses(void) const;
  virtual unsigned numVars(void) const;

  virtual bool solve(void);
  virtual bool solve(const std::vector<signed> &assumptions);

  virtual ModelValue get(signed l) const;

  virtual Expression getInterpolant(const std::vector<signed> &A);
  virtual bool addConstraint(const Expression &e);
  virtual signed addExtension(const Expression &e);

  virtual Expression getModel(void) const;
  
  virtual void setVerbose(int v);

  void setInterpolator(InterpolationMode i) { interpolationMode = i; }
  void setSequential(bool v) { sequential = v; }

public:
  unsigned interpolants_imported;
  unsigned rounds;

protected:
  unsigned cores;
  unsigned maxVar;  
  InterpolationMode interpolationMode;
  std::vector<SATSolver*> s;
  std::vector<ExpressionManager*> ms;
  Decomposition *d;
  Translation translation;
  std::vector<signed> temp;
  SATSolver *crossModelSolver;
  bool sequential;

  void init(unsigned n);
  void showDistribution(void) const;
    
  std::vector<std::vector<signed> > assumptions;

  bool solvePartitions(void);
  bool crossModelCheck(void);
  bool reconcile(void);
  bool reconcile(unsigned i, unsigned j);

  class InterpolantSet : public std::vector<Expression> {};
  std::vector<InterpolantSet> interpolants;
  
  class ModelSet : public std::vector<Expression> {};
  std::vector<ModelSet> models;
  std::vector<ModelSet> new_models;
  std::vector<std::vector<signed> > model_vars;

  bool importInterpolants(unsigned x);

  void showModels(void) const;
  Expression getModel(unsigned i) const;
};

#endif