// Copyright (C) 2011 Microsoft Research
// CM Wintersteiger, 2011

#ifndef _PARTITION_H_
#define _PARTITION_H_

#include <vector>

#include <expression.h>
#include <ExpressionManager.h>

#include "minisat1p.h"
#include "satsolver.h"
#include "interpolation_mode.h"
#include "interpolator.h"

class Partition : public SATSolver
{
public:  
  // Partition(SharedVariables &sharedVariables, unsigned id, unsigned verbosity=0);
  Partition(ExpressionManager &em, SharedVariables &sharedVariables, unsigned id, unsigned verbosity=0, bool proof = true);
  ~Partition(void);

  void setInterpolationMode(InterpolationMode interpolationMode); 
  void setInterpolationMode(InterpolationMode interpolationMode, SharedVariables &masterSharedVariables);
  void setInterpolationMode(ExpressionManager &em, InterpolationMode interpolationMode, SharedVariables &masterSharedVariables);

  Expression getInterpolant(const std::vector<signed> &assumptions);

  virtual bool addClause(const std::vector<signed> &literals);
  virtual bool addUnit(signed l) { throw std::exception("NYI: addUnit"); };
  virtual void setVariableMax(unsigned n) { v.reserve(n+1); solver->setVariableMax(n); };
  virtual void setClauseMax(unsigned n) { solver->setClauseMax(n); };

  virtual unsigned numClauses(void) const { return solver->numClauses(); };
  virtual unsigned numVars(void) const { return solver->numVars(); };
  virtual signed addVar(void) { return solver->addVar(); };

  virtual bool solve(void) { return solver->solve(); }
  virtual bool solve(const std::vector<signed> &assumptions) { return solver->solve(assumptions); }

  virtual ModelValue get(signed l) const { return solver->get(l); }

  //virtual bool addConstraint(CExpression &e){ throw std::exception("NYI: addConstraint"); }
  
  virtual bool addConstraint(CExpression &e) { return solver->addConstraint(e); }
  virtual signed addExtension(CExpression &e) { throw std::exception("NYI: addExtension"); }

  virtual Expression getModel(void) const { throw std::exception("NYI: getModel"); }

  const VariableOccurrence &variablesOccurrence(void) const { return v; }

  ExpressionManager &em(void) { return m; }

  SATSolver * getSolver(void) {return solver;}

  void insertVariableOccurrence(unsigned t) { v.setOccurs(t); }

  bool occurs(unsigned x) { return v.occurs(x); }
  
  void clearVariableOccurrence(void) { v.clear(); }

  void newSolver(void) { delete solver; solver = new MiniSAT_1p(m, true, MiniSAT_1p::LIFTING); }

protected:
  unsigned id;
  ExpressionManager & m;
  SATSolver *solver;  
  Interpolator *interpolator;
  VariableOccurrence v;
  SharedVariables &sharedVariables;

  inline void print(const char* format, ...) const
  {
    if (verbosity<=0) return;
    va_list args;
    va_start(args, format);
    vprintf(format, args);
    va_end(args);
  }
};

#endif