﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace trajectoryConcatenation
{
    class tensorDec
    {
        int month, day, timeSliceSmall, timeSliceBig;
        int allRoadTensor = 196307;
        int allDriver = 32670;
        double[, ,] S;
        double[,] R;
        double[,] U;
        double[,] T;
        int StartTimeSlice = 0;

        public tensorDec(int _month, int _day, int _timeSliceSmall, int _timeSliceBig)
        {
            S = new double[5 + 1, 5 + 1, 5 + 1];
            R = new double[allRoadTensor + 1 , 5 + 1];
            U = new double[allDriver + 1, 5 + 1];
            T = new double[8 + 1, 5 + 1];
            
            month = _month;
            day = _day;
            timeSliceSmall = _timeSliceSmall;
            timeSliceBig = _timeSliceBig;

            if (timeSliceSmall % 4 == 3)
            {
                StartTimeSlice = timeSliceSmall - 2;
            }
            else
            {
                StartTimeSlice = timeSliceSmall;
            }

            // read core tensor S
            StreamReader sr = new StreamReader("S.txt");
            for (int x = 1; x <= 5; x++)
                for (int y = 1; y <= 5; y++)
                    for (int z = 1; z <= 5; z++)
                    { 
                        string line = sr.ReadLine();
                        double element = Convert.ToDouble(line);
                        S[x, y, z] = element;
                    }
            sr.Close();

            // read latent factor matrix R U T
            sr = new StreamReader("R.txt");
            for (int x = 1; x <= allRoadTensor; x++)
                for (int y = 1; y <= 5; y++)
                {
                    string line = sr.ReadLine();
                    double element = Convert.ToDouble(line);
                    R[x, y] = element;
                }
            sr.Close();

            sr = new StreamReader("U.txt");
            for (int x = 1; x <= allDriver; x++)
                for (int y = 1; y <= 5; y++)
                {
                    string line = sr.ReadLine();
                    double element = Convert.ToDouble(line);
                    U[x, y] = element;
                }
            sr.Close();

            sr = new StreamReader("T.txt");
            for (int x = 1; x <= 8; x++)
                for (int y = 1; y <= 5; y++)
                {
                    string line = sr.ReadLine();
                    double element = Convert.ToDouble(line);
                    T[x, y] = element;
                }
            sr.Close();
        }

        double computeElementValue(int road, int driver, int timeSlice)  //compute the element value
        {
            double value = 0;
            int roadX = road;
            int driverY = driver;
            int timeSliceZ = timeSlice - StartTimeSlice + 1 + 4;

            // here below is a ttv in matlab for tucker tensor
            double[,] step1 = new double[5 + 1, 5 + 1];
            double[] Ri = new double[5 + 1];
            double[] Uj = new double[5 + 1];
            double[] Tk = new double[5 + 1];

            for (int i = 1; i <= 5; i++)
            {
                Ri[i] = R[roadX, i];
            }
            for (int i = 1; i <= 5; i++)
            {
                Uj[i] = U[driverY, i];
            }
            for (int i = 1; i <= 5; i++)
            {
                Tk[i] = T[timeSliceZ, i];
            }

            for (int x = 1; x <= 5; x++)
                for (int y = 1; y <= 5; y++)
                    for (int z = 1; z <= 5; z++)
                    {
                        step1[y, z] += S[x, y, z] * Ri[x];
                    }

            double[] step2 = new double[5 + 1];
            for (int y = 1; y <= 5; y++)
                for (int z = 1; z <= 5; z++)
                {
                    step2[z] += step1[y, z] * Uj[y];
                }

            double step3 = 0;
            for (int z = 1; z <= 5; z++)
            {
                step3 += step2[z] * Tk[z];
            }

            value = step3;
            return value;
        }

        public double getElementValue(int road, int driver)
        {
            double value;
            double valueSmall = computeElementValue(road, driver, timeSliceSmall);
            double valueBig = computeElementValue(road, driver, timeSliceBig);
            
            if (valueSmall > 1 && valueBig > 1)
            {
                value = (valueSmall + valueBig) / 2;
            }
            else if (valueSmall > 1)
            {
                value = valueSmall;
            }
            else if (valueBig > 1)
            {
                value = valueBig;
            }
            else
            {
                value = 0;
            }

            return value;
        }
    }
}
