﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace trajectoryConcatenation
{
    public class trie //this is the class for suffix tree(trie)
    {
        int theta;
        int totalNumber;
        trieNode[] root;
        int minFrequent;
        Stack<int> fst = new Stack<int>();
        List<traj> returnTraj;

        public trie(int _totalNumber, int _theta)  //theta == max length of trie tree
        {
            totalNumber = _totalNumber;
            theta = _theta;
            root = new trieNode[totalNumber + 1];
            
            for (int i = 1; i <= totalNumber; i++)
            {
                root[i] = new trieNode(i, 0);
            }
        }

        //this function is adding trajectories into the suffic tree(trie)
        //road contains a list of road segments, travelTime contains a list of travel time on corresponding road segments 
        //driverTrajNum denotes dirver D's Tth trajectory contains the sub-trajectory this trieNode represents  
        public void addTraj(List<int> road, List<double> travelTime, Tuple<int, int> driverTrajNum)
        {
            trieNode currentNode;

            for (int i = 0; i <= road.Count - theta; i++)
            {
                root[road[i]].count++;
                root[road[i]].driverTrajPool .Add(driverTrajNum);
                root[road[i]].travelTime.Add(travelTime[i]);
                currentNode = root[road[i]];
                double nodeTravelTime = travelTime[i];
                
                for (int j = i + 1; j <= i + theta - 1; j++)
                {
                    nodeTravelTime += travelTime[j];
                    int nodeNum = road[j];
                    currentNode = searchChild(currentNode, nodeNum, nodeTravelTime, driverTrajNum);
                }
            }
        }

        trieNode searchChild(trieNode node, int num, double travelTime, Tuple<int, int> driverTrajNum)
        {
            trieNode returnNode;

            if (node.child.Count == 0)
            {
                node.child.Add(new trieNode(num, travelTime, 1, driverTrajNum));
                returnNode = node.child[0];
            }
            else
            {
                int index = 0;

                while (index < node.child.Count && node.child[index].number != num)
                {
                    index++;
                }

                if (!(index == node.child.Count))
                {
                    node.child[index].count++;
                    node.child[index].driverTrajPool.Add(driverTrajNum);
                    node.child[index].travelTime.Add(travelTime);
                    returnNode = node.child[index];
                }
                else
                {
                    node.child.Add(new trieNode(num, travelTime, 1, driverTrajNum));
                    returnNode = node.child[index];
                }
            }

            return returnNode;
        }

        //this function is adding frequent patterns into the suffic tree(trie)
        public void addTrajForFST(List<int> road, Tuple<int, int> driverTrajNum)
        {
            trieNode currentNode;

            root[road[0]].count++;
            root[road[0]].driverTrajPool.Add(driverTrajNum);
            currentNode = root[road[0]];

            for (int i = 1; i < road.Count; i++)
            {
                int nodeNum = road[i];
                currentNode = searchChild(currentNode, nodeNum, 0, driverTrajNum);
            }
        }

        //get the support of the sub-trajectory this trieNode represents 
        public int getFrequency(List<int> road, int start, int end)
        {
            trieNode currentNode;
            int frequency = 0 ;
            if (root[road[start]].count == 0)
            {
                return frequency;
            }
            else
            {
                currentNode = root[road[start]];
                for (int i = start + 1; i <= end; i++)
                {
                    int nodeNum = road[i];
                    bool foundChild = false;

                    for (int c = 0; c < currentNode.child.Count; c++)
                    {
                        if (currentNode.child[c].number == nodeNum)
                        {
                            foundChild = true;
                            currentNode = currentNode.child[c];
                            break;
                        }
                    }

                    if (!foundChild)
                    {
                        break;
                    }
                    if (foundChild && i == end)
                    {
                        frequency = currentNode.count;
                    }
                }
            }

            return frequency;
        }

        //get the drivers and trajectories that traverse the sub-trajectory this trieNode represents 
        public List<Tuple<int, int>> getDriverTrajPool(List<int> road, int start, int end)
        {
            trieNode currentNode;
            List<Tuple<int, int>> frequency = new List<Tuple<int, int>>();
            
            if (root[road[start]].count == 0)
            {
                return frequency;
            }
            else
            {
                currentNode = root[road[start]];
                for (int i = start + 1; i <= end; i++)
                {
                    int nodeNum = road[i];
                    bool foundChild = false;
                    
                    for (int c = 0; c < currentNode.child.Count; c++)
                    {
                        if (currentNode.child[c].number == nodeNum)
                        {
                            foundChild = true;
                            currentNode = currentNode.child[c];
                            break;
                        }
                    }

                    if (!foundChild)
                    {
                        break;
                    }
                    if (foundChild && i == end)
                    {
                        frequency = currentNode.driverTrajPool;
                    }
                }
            }

            return frequency;
        }

        //get the travel time different drivers spent on the sub-trajectory this trieNode represents 
        public List<double> getTravelTime(List<int> road, int start, int end)
        {
            trieNode currentNode;
            List<double> frequency = new List<double>();

            if (root[road[start]].count == 0)
            {
                return frequency;
            }
            else
            {
                currentNode = root[road[start]];
                for (int i = start + 1; i <= end; i++)
                {
                    int nodeNum = road[i];
                    bool foundChild = false;
                    
                    for (int c = 0; c < currentNode.child.Count; c++)
                    {
                        if (currentNode.child[c].number == nodeNum)
                        {
                            foundChild = true;
                            currentNode = currentNode.child[c];
                            break;
                        }
                    }

                    if (!foundChild)
                    {
                        break;
                    }
                    if (foundChild && i == end)
                    {
                        frequency = currentNode.travelTime;
                    }
                }
            }
            return frequency;
        }

        //get the sub-trajectorise have supports large than or equal to _minfrequent
        public List<traj> print(int _minfrequent)
        {
            returnTraj = new List<traj>();
            minFrequent = _minfrequent;
            trieNode currentNode;
            for (int i = 1; i <= totalNumber; i++)
            {
                fst.Clear();
                currentNode = root[i];
                deepSearch(currentNode);
            }
            return returnTraj;
        }

        Boolean deepSearch(trieNode node)
        {
            Boolean childLongest = false;
            Boolean havePrinted = false;

            if (node.count >= minFrequent)
            {
                if (node.child.Count != 0)
                {
                    for (int c = 0; c < node.child.Count; c++)
                    {
                        fst.Push(node.number);
                        bool longest = deepSearch(node.child[c]);
                        fst.Pop();
                        if (longest)
                        {
                            childLongest = true;
                        }
                    }
                }

                if (!childLongest)
                {
                    traj newTraj = new traj();
                    
                    int[] hello = fst.ToArray();
                    for (int j = hello.Length - 1; j >= 0; j--)
                    {
                        newTraj.addRoad(hello[j]);
                    }

                    newTraj.addRoad(node.number);
                    newTraj.addDriverTraj(node.driverTrajPool );
                    newTraj.addFrequent(node.count);
                    havePrinted = true;
                    returnTraj.Add(newTraj);  
                }
            }

            if (childLongest)
            {
                havePrinted = true;
            }

            return havePrinted;
        }
    }
}
