/*
Attempt to prove:

A(x){D[x] := D[x] + 5;}
I(x){if(x){I(N[x]); A(x);}}
J(x){if(x){A(x); J(N[x]);}}


Special instances of Mutual Summary (MS)

1. EQ(I,J) = (x1 == x2 && old(D1) == old(D2)) ==> D1 == D2
2. Det(I)  = EQ(I,I)
3. Commute(I,J) = EQ(GIJ, GJI) where
	GIJ(x,y){inline I(x); inline J(y);}
	GJI(x,y){inline J(y); inline I(x);}
        R_GIJ(x,y,g,g') <==> \exist g''. R_I(x,g,g'') && R_J(y,g'',g')
4. RelTerm(GIJ,GJI) //relative termination of I;J and J;I


Axioms
--------
R1) EQ(I,J)
R2) Commute(I,I) //Do we need this? 
R3) Commute(I,A)
R4) Commute(A,A)
R5) RelTerm(IA,AI)
R6) RelTerm(AA,AA) //Do we need this?
R7) Det(A) 
R8) Det(I)

Proof obligations (main):

///////////////////
(A) EQ(I,J)
///////////////////
Premises
P1) {D0} I(N[x]); {Da}  A(x); {D1} 
P2) {D0} A(x) {Db}  J(N[x]); {D2} 
P3) {D1 != D2}

PROOF
D1) {D0} J(N[x]); {Da} A(x); {D1} //R1, P1
D2) {D0} A(x); {Dc} J(N[x]); {D1} //R3, D1
False //P2, D2, R7, R8, P3


///////////////////
(B) Commute(I,A)
///////////////////
Premises
P1) {D0} I(N[x]); {Da}  A(x); {Db} A(y); {D1} 
P2) {D0} A(y); {Dc}  I(N[x]);  {Dd} A(x); {D2} 
P3) {D1 != D2}

PROOF
D1) {D0} I(N[x]); {Da'}  A(y); {Db'}   //R5, P2
D2) {D0} I(N[x]); {Da'}  A(y); {Dd}   //D1, R3
D3) {D0} I(N[x]); {Da}  A(y); {Dd}    //D2, R8
D4) {D0} I(N[x]); {Da}  A(y); {Dd} A(x); (D2} //D3, R7
D5) {D0} I(N[x]); {Da}  A(x); {Dd'} A(y); {D2} //D4, R3, P1
D6) False  //D4, P1, 


///////////////////
(B) RelTerm(IA,AI)
///////////////////



*/


const N1: [int]int; //the next field does not change
var D1: [int]int; //1st version



procedure {:inline 1} Node1Body(x1:int)
modifies D1;
{
//   D1[x1] := D1[x1*2] + 5;
   D1[x1] := D1[x1] + 5;
}

procedure {:inline 1} Init1Body(x1:int, assertTermination:bool, assumeTermination:bool)
modifies D1;
{
   if (x1 != 0) {
       if (assertTermination) {
           assert T_Init1(N1[x1],D1);
       } 
       if (assumeTermination) {
           assume T_Init1(N1[x1],D1);
       }
       call Init1(N1[x1]);

       if (assertTermination) {
           assert T_Node1(x1,D1);
       } 
       if (assumeTermination) {
           assume T_Node1(x1,D1);
       }
       call Node1(x1); 
   }
}

procedure {:inline 1} Init2Body(x2:int)
modifies D1;
{
   if (x2 != 0) {
       call Node1(x2); 
       call Init2(N1[x2]);
   }
}


/////////////////////////////////////////////

function R_Node1(x1:int, D1: [int]int, D1': [int]int):bool;
function R_Init1(x1:int, D1: [int]int, D1': [int]int):bool;
function R_Init2(x2:int, D2: [int]int, D2': [int]int):bool;

procedure  Node1(x1:int);
modifies D1;
ensures R_Node1(x1, old(D1), D1);

procedure  Init1(x1:int);
modifies D1;
ensures R_Init1(x1, old(D1), D1);

procedure  Init2(x2:int);
modifies D1;
ensures R_Init2(x2, old(D1), D1);

function T_Node1(x1:int, D1: [int]int):bool
{
   (exists D1':[int]int :: {R_Node1(x1,D1,D1')} R_Node1(x1,D1,D1'))
}
function T_Init1(x1:int, D1: [int]int):bool
{
   (exists D1':[int]int :: {R_Init1(x1,D1,D1')} R_Init1(x1,D1,D1'))
}



/////////////////////////////////////////////////////////////////
// AXIOMS
///////////////////////////////////////////////////////////////

function  C_Init1_Init2(
          x1:int, 
          x2:int, 
          D1:[int]int, 
          D1':[int]int, 
          D2:[int]int,
          D2':[int]int
          ): bool 
{
     (x1 == x2 && D1 == D2) ==> (D1' == D2')
}

//termination condition
function  CT_Init1_Node1(
          x1:int, 
          x2:int, 
          D1:[int]int, 
          D2:[int]int
          ): bool 
{
	true
}



//EQ(Init1, Init2)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int, D2':[int]int::
	{R_Init1(x1, D1, D1'), R_Init2(x2, D2, D2')}
          (
          (R_Init1(x1, D1, D1') && R_Init2(x2, D2, D2'))
          ) ==> 
         C_Init1_Init2(x1,x2,D1,D1',D2,D2')          
);


//Commutes(Node1, Node1)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int, D3:[int]int, D3':[int]int :: 
	{R_Node1(x1, D1, D1'), R_Node1(x2, D1', D2), R_Node1(x2, D1, D3), R_Node1(x1, D3, D3')}
          (
          (R_Node1(x1, D1, D1') && R_Node1(x2, D1', D2)) &&
	  (R_Node1(x2, D1, D3 ) && R_Node1(x1, D3, D3'))  
          ) ==> 
          D2 == D3'
);


//Commutes(Init1, Node1)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int, D3:[int]int, D3':[int]int :: 
	{R_Init1(x1, D1, D1'), R_Node1(x2, D1', D2), R_Node1(x2, D1, D3), R_Init1(x1, D3, D3')}
          (
          (R_Init1(x1, D1, D1') && R_Node1(x2, D1', D2)) &&
	  (R_Node1(x2, D1, D3 ) && R_Init1(x1, D3, D3'))  
          ) ==> 
          D2 == D3'
);

//Relative termination(Init1, Node1)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int:: 
      {R_Init1(x1, D1, D1'), R_Node1(x2, D1', D2)}
      (exists D3:[int]int, D3':[int]int :: 
      {R_Node1(x2, D1, D3 ), R_Init1(x1, D3, D3')}   	
          (
          (R_Init1(x1, D1, D1') && R_Node1(x2, D1', D2)) ==>
	  (R_Node1(x2, D1, D3 ) && R_Init1(x1, D3, D3'))  
          )
       )
       
);

//Relative termination(Node1, Init1)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int:: 
      {R_Node1(x1, D1, D1'), R_Init1(x2, D1', D2)}
      (exists D3:[int]int, D3':[int]int :: 
      {R_Init1(x2, D1, D3 ), R_Node1(x1, D3, D3')}   	
          (
          (R_Node1(x1, D1, D1') && R_Init1(x2, D1', D2)) ==>
	  (R_Init1(x2, D1, D3 ) && R_Node1(x1, D3, D3'))  
          )
       )
);

//Relative termination(Node1, Node1)
axiom(
      forall x1:int, x2:int, D1:[int]int, D1':[int]int, D2:[int]int:: 
      {R_Node1(x1, D1, D1'), R_Node1(x2, D1', D2)}
      (exists D3:[int]int, D3':[int]int :: 
      {R_Node1(x2, D1, D3 ), R_Node1(x1, D3, D3')}   	
          (
          (R_Node1(x1, D1, D1') && R_Node1(x2, D1', D2)) ==>
	  (R_Node1(x2, D1, D3 ) && R_Node1(x1, D3, D3'))  
          )
       )
       
);


//Deterministic(Node1)
axiom(
      forall x1:int,  D1:[int]int, D1':[int]int, D2':[int]int:: 
      {R_Node1(x1, D1, D1'), R_Node1(x1, D1, D2')}
          (R_Node1(x1, D1, D1') && R_Node1(x1, D1, D2')) ==>
           D1' == D2'                      
);


//Deterministic(Init1)
axiom(
      forall x1:int,  D1:[int]int, D1':[int]int, D2':[int]int:: 
      {R_Init1(x1, D1, D1'), R_Init1(x1, D1, D2')}
          (R_Init1(x1, D1, D1') && R_Init1(x1, D1, D2')) ==>
           D1' == D2'                      
);




/////////////////////////////////////////////
// CHECKS 
/////////////////////////////////////////////


procedure CheckEQ_Init1_Init2(x1:int, x2:int)
modifies D1;
{
   var D0 : [int]int;
   call Init1Body(x1,false,false);
   D0 := D1;
   D1 := old(D1);
   call Init2Body(x2);   
   
   assert C_Init1_Init2(x1,x2,old(D1),D0,old(D1),D1);          
}


procedure CheckCommute_Node1_Node1(x1:int, x2:int)
modifies D1;
{
   var D0: [int]int;

   call Node1Body(x1);
   call Node1Body(x2);
   
   D0 := D1;
   D1 := old(D1);
   
   call Node1Body(x2);
   call Node1Body(x1);

   //the checks use concrete instructions, hence extentionality is needed
   assert  D1 == D0 || (forall x:int :: D1[x] == D0[x]); //extentionality
}


procedure CheckCommute_Init1_Node1(x1:int, x2:int)
modifies D1;
{
   var D0: [int]int;

   call Init1Body(x1,false,false);
   call Node1(x2);
   
   D0 := D1;
   D1 := old(D1);
   
   call Node1(x2);
   call Init1Body(x1,false,false);
  
   assert D1 == D0 ; // (forall x:int :: D1[x] == D0[x]); //extentionality
}


procedure Check_RelTerm_Init1_Node1(x1:int, x2:int)
modifies D1;
{
   var D0: [int]int;

   assume CT_Init1_Node1(x1,x2,old(D1),old(D1));

   call Init1Body(x1,false,true);
   assume T_Node1(x2, D1);
   call Node1(x2);
   
   D0 := D1;
   D1 := old(D1);

   assert T_Node1(x2, D1);
   call Node1(x2);
   call Init1Body(x1,true,false);
}


procedure Check_RelTerm_Node1_Init1(x1:int, x2:int)
modifies D1;
{
   var D0: [int]int;

   assume CT_Init1_Node1(x1,x2,old(D1),old(D1));

   assume T_Node1(x2, D1);
   call Node1(x2);
   call Init1Body(x1,false,true);
   
   D0 := D1;
   D1 := old(D1);

   call Init1Body(x1,true,false);
   assert T_Node1(x2, D1);
   call Node1(x2);

}


procedure Check_RelTerm_Node1_Node1(x1:int, x2:int)
modifies D1;
{
   var D0: [int]int;

//   assume CT_Node1_Node1(x1,x2,old(D1),old(D1));

   assume T_Node1(x1, D1);
   call Node1(x1);
   assume T_Node1(x2, D1);
   call Node1(x2);

   
   D0 := D1;
   D1 := old(D1);

   assert T_Node1(x2, D1);
   call Node1(x2);
   assert T_Node1(x1, D1);
   call Node1(x2);

}


procedure CheckDet_Node1(x1:int)
modifies D1;
{
   var D0: [int]int;

   call Node1Body(x1);

   D0 := D1;
   D1 := old(D1);

   call Node1Body(x1);

   assert(D0 == D1);
}


procedure CheckDet_Init1(x1:int)
modifies D1;
{
   var D0: [int]int;

   call Init1Body(x1,false,false);

   D0 := D1;
   D1 := old(D1);

   call Init1Body(x1,false,false);

   assert(D0 == D1);
}

