var g1: int;
var g2: int;

////////////////////////////
// Program 1
////////////////////////////

procedure {:inline 1} Foo1Body(x1:int)
modifies g1;
requires x1 >= 0;
{
   if (x1 < 100) { 
        g1 := g1 + x1;
        call Foo1(x1 + 1);
   }

}

////////////////////////////
// Program 1
////////////////////////////

procedure {:inline 1} Foo2Body(x2:int) 
modifies g2;
requires x2 >= 0;
{
   if (x2 < 100) { 
        g2 := g2 + 2*x2;
        call Foo2(x2 + 1);
   }
}

//////////////////////////////////////
// Mutual summary
//////////////////////////////////////
function C_Foo1_Foo2(x1: int, g1:int, g1':int, x2: int, g2:int, g2':int): bool
{
  (x1 == x2 && g1 <= g2)  ==> g1' <= g2'
}

///////////////////////////////////////////////////////
// Can be automatically generated
///////////////////////////////////////////////////////


function R_Foo1(x1: int, g1:int, g1':int) returns (bool);
function R_Foo2(x2: int, g2:int, g2':int) returns (bool);


procedure Foo1(x1:int);
modifies g1;
free ensures R_Foo1(x1, old(g1), g1);

procedure {:inline 1} Foo2(x2:int); 
modifies g2;
free ensures R_Foo2(x2, old(g2), g2);

axiom (forall x1:int, g1:int, g1':int, x2:int, g2:int, g2':int :: 
       {R_Foo1(x1, g1, g1'), R_Foo2(x2, g2, g2')} 
       (
        R_Foo1(x1, g1, g1') && R_Foo2(x2, g2, g2')) ==> 
        C_Foo1_Foo2(x1, g1, g1', x2, g2, g2')
       );



procedure MUTUALCHECK_F1_F2(x1:int, x2:int)
modifies g1, g2;
requires x1 >= 0;
requires x2 >=0;
{
   call Foo1Body(x1);
   call Foo2Body(x2);
   assert(C_Foo1_Foo2(x1, old(g1), g1, x2, old(g2), g2));
}
