var a1:[int]int;
var a2:[int]int;

const g:int;
const n:int;

///////////////////////////////////////////////////////////////////////////////

function R_While1(a1:[int]int, a1':[int]int, i1:int, r1:int):bool;

procedure While1(i1:int) returns(r1:int);
  modifies a1;
  free ensures R_While1(old(a1), a1, i1, r1);

procedure {:inline 1} WhileBody1(i1:int) returns(r1:int)
  modifies a1;
{
  var i1':int;
  var t1:int;
  var u1:int;
  var v1:int;

  i1' := i1;
  if(i1' < n) {
    t1 := g;
    u1 := t1 * i1';
    v1 := u1 + 3;
    a1[i1'] := v1;
    i1' := i1' + 1;
    call r1 := While1(i1');
    return;
  }
  r1 := i1';
  return;
}

function R_While2(a2:[int]int, a2':[int]int, i2:int, t2:int, v2:int, r2:int):bool;

procedure While2(i2:int, t2:int, v2:int) returns(r2:int);
  modifies a2;
  free ensures R_While2(old(a2), a2, i2, t2, v2, r2);

procedure {:inline 1} WhileBody2(i2:int, t2:int, v2:int) returns(r2:int)
  modifies a2;
{
  var i2':int;
  var v2':int;

  i2' := i2;
  v2' := v2;
  if (i2' < n) {
    a2[i2'] := v2';
    i2' := i2' + 1;
    v2' := v2' + t2;
    call r2 := While2(i2', t2, v2');
    return;
  }
  r2 := i2';
  return;
}

function CW(a1:[int]int, a1':[int]int, i1:int, r1:int, a2:[int]int, a2':[int]int, i2:int, t2:int, v2:int, r2:int):bool {
  (i1 == i2 && t2 == g && v2 == 3 + g * i2 && a1 == a2) ==> (r1 == r2 && a1' == a2')
}

axiom (forall a1:[int]int, a1':[int]int, i1:int, r1:int, a2:[int]int, a2':[int]int, i2:int, t2:int, v2:int, r2:int::
  {R_While1(a1, a1', i1, r1), R_While2(a2, a2', i2, t2, v2, r2)}
  R_While1(a1, a1', i1, r1) && R_While2(a2, a2', i2, t2, v2, r2) ==>
    CW(a1, a1', i1, r1, a2, a2', i2, t2, v2, r2));

procedure Check_While1_While2(i1:int, i2:int, t2:int, v2:int)
  modifies a1, a2;
{
  var r1:int;
  var r2:int;
  call r1 := WhileBody1(i1);
  call r2 := WhileBody2(i2, t2, v2);
  assert CW(old(a1), a1, i1, r1, old(a2), a2, i2, t2, v2, r2);
}

///////////////////////////////////////////////////////////////////////////////

function R_Foo1(a1:[int]int, a1':[int]int, r1:int):bool;

procedure Foo1() returns(r1:int);
  modifies a1;
  free ensures R_Foo1(old(a1), a1, r1);

procedure {:inline 1} FooBody1() returns(r1:int)
  modifies a1;
{
  var i1:int;
  i1 := 0;
  call r1 := WhileBody1(i1); // INLINED
  return;
}

function R_Foo2(a2:[int]int, a2':[int]int, r2:int):bool;

procedure Foo2() returns(r2:int);
  modifies a2;
  free ensures R_Foo2(old(a2), a2, r2);

procedure {:inline 1} FooBody2() returns(r2:int)
  modifies a2;
{
  var i2:int;
  var t2:int;
  var v2:int;

  i2 := 0;
  if (n > 0) {
    t2 := g;
    v2 := 3;
    a2[i2] := v2;
    i2 := i2 + 1;
    v2 := v2 + t2;
    call r2 := While2(i2, t2, v2);
    return;
  }
  r2 := i2;
  return;
}

function CF(a1:[int]int, a1':[int]int, r1:int, a2:[int]int, a2':[int]int, r2:int):bool {
  (a1 == a2) ==> (r1 == r2 && a1' == a2')
}

axiom (forall a1:[int]int, a1':[int]int, r1:int, a2:[int]int, a2':[int]int, r2:int::
  {R_Foo1(a1, a1', r1), R_Foo2(a2, a2', r2)}
  R_Foo1(a1, a1', r1) && R_Foo2(a2, a2', r2) ==>
    CF(a1, a1', r1, a2, a2', r2));

procedure Check_Foo1_Foo2()
  modifies a1, a2;
{
  var r1:int;
  var r2:int;
  call r1 := FooBody1();
  call r2 := FooBody2();
  assert CF(old(a1), a1, r1, old(a2), a2, r2);
}

