/***********

  Factorial1(n)
  {
    if (n == 0) return 1;
    else return n * Factorial1(n - 1)
  }

  Factorial2(n)
  {
    int r = 1;
    int i = n;
    while (i != 0)
    {
      r := r * i;
      i := i - 1;
    }
    return r;
  }

***********/

function R_Factorial1(n1:int, r1:int):bool;

procedure Factorial1(n1:int) returns(r1:int);
  free ensures R_Factorial1(n1, r1);

procedure {:inline 1} FactorialBody1(n1:int) returns(r1:int)
{
  var rr:int;
  if (n1 == 0)
  {
    r1 := 1;
  }
  else
  {
    call rr := Factorial1(n1 - 1);
    r1 := n1 * rr;
  }
}

function R_While2(i2:int, r2:int, r2':int):bool;

procedure While2(i2:int, r2:int) returns(r2':int);
  free ensures R_While2(i2, r2, r2');

procedure {:inline 1} WhileBody2(i2:int, r2:int) returns(r2':int)
{
  if (i2 != 0)
  {
    call r2' := While2(i2 - 1, r2 * i2);
    return;
  }
  r2' := r2;
}

function CW(n1:int, r1:int, i2:int, r2:int, r2':int):bool
{
  (n1 == i2) ==> (r2 * r1 == r2')
}

axiom (forall n1:int, r1:int, i2:int, r2:int, r2':int::
  {R_Factorial1(n1, r1), R_While2(i2, r2, r2')}
  R_Factorial1(n1, r1) && R_While2(i2, r2, r2') ==>
    CW(n1, r1, i2, r2, r2'));

procedure Check_Factorial1_While2(n1:int, i2:int, r2:int)
{
  var r1:int;
  var r2':int;

  call r1 := FactorialBody1(n1);
  call r2' := WhileBody2(i2, r2);

  assert CW(n1, r1, i2, r2, r2');
}

///////////////////////////////////////////////////

function R_Factorial2(n2:int, r2:int):bool;

procedure Factorial2(n2:int) returns(r2:int);
  free ensures R_Factorial2(n2, r2);

procedure {:inline 1} FactorialBody2(n2:int) returns(r2:int)
{
  call r2 := WhileBody2(n2, 1);
}

function CF(n1:int, r1:int, n2:int, r2:int):bool
{
  (n1 == n2) ==> (r1 == r2)
}

axiom (forall n1:int, r1:int, n2:int, r2:int::
  {R_Factorial1(n1, r1), R_Factorial2(n2, r2)}
  R_Factorial1(n1, r1) && R_Factorial2(n2, r2) ==>
    CF(n1, r1, n2, r2));

procedure Check_Factorial1_Factorial2(n1:int, n2:int)
{
  var r1:int;
  var r2:int;

  call r1 := FactorialBody1(n1);
  call r2 := FactorialBody2(n2);

  assert CF(n1, r1, n2, r2);
}

