//Parameterized version of software pipelining
//We don't do any renaming of globals/params

/* 
**** Example of parameterized dowhile ***********
A(){
  i := 0;
While1: //FLABEL
  if (i < E(n)){
      a[i] := S1(a[i]);
      b[i] := S2(a[i],b[i]);
      i := i + 1;
      goto While1;
  } 
}

B(){
  i := 0;
  a[i] := S1(a[i]);
While2: //FLABEL
  if (i < E(n) - 1)){
      a[i+1] := S1(a[i+1]);
      b[i]   := S2(a[i],b[i]);
      i := i + 1;
      goto While2;
  } 
  b[i] := S2(a[i], b[i]);
  i := i + 1;
}
 
/////////// After loop extraction /////////////

*/

type mytype = [int]int;

//two globals
var a:mytype;
var b:mytype;

//parameter
const n:int;

axiom (E(n) > 0); //Needed for this transformation

function E(i:int):int;
function uA(x:mytype, i:int):mytype;
function uB(x:mytype, i:int):mytype;

function S1(x:int): int;
function S2(x:int, y:int): int;

////////////////////////// SIDE 1 ////////////////////////////////////

procedure {:inline 1} ABody()
  modifies a,b;
{
  var i:int;
  var r:int;
 
  i := 0;
  call r := While1Body(i); 
}

procedure  {:inline 1}  While1Body(i:int) returns (r:int)
  modifies a,b;
{
  var i':int;

  i' := i;
  if (i' < E(n)){
     a[i'] := S1(a[i']);
     b[i'] := S2(a[i'],b[i']);
     i' := i' + 1;
     call r := While1(i'); 
     return;
  }
  r := i';
  return; 
}

////////////////////////// SIDE 2 ////////////////////////////////////

procedure {:inline 1} BBody()
  modifies a,b;
{
  var i:int;
  var r:int;
 
  i := 0;
  a[i] := S1(a[i]);
  call r := While2(i); //inline 
}

procedure  {:inline 1}  While2Body(i:int) returns (r:int)
  modifies a,b;
{
  var i':int;

  i' := i;
  if (i' < E(n) - 1){
     a[i'+1] := S1(a[i'+1]);
     b[i']   := S2(a[i'],b[i']);
     i' := i' + 1;
     call r := While2(i'); 
     return;
  }
  b[i'] := S2(a[i'],b[i']);
  i' := i' + 1;
  r := i';
  return; 
}



/////////////////////// COMPARISONS /////////////////////////////////////

function R_A(a:mytype, a':mytype, b:mytype, b':mytype):bool;
function R_While1(a:mytype, a':mytype, b:mytype, b':mytype, i:int, r:int):bool;

procedure While1(i:int) returns (r:int);
  modifies a, b;
  free ensures R_While1(old(a), a, old(b), b, i, r);

function R_B(a:mytype, a':mytype, b:mytype, b':mytype):bool;
function R_While2(a:mytype, a':mytype, b:mytype, b':mytype, i:int, r:int):bool;
function R_While3(a:mytype, a':mytype, b:mytype, b':mytype, i:int, r:int):bool;

procedure While2(i:int) returns (r:int);
  modifies a, b;
  free ensures R_While2(old(a), a, old(b), b, i, r);

procedure While3(i:int) returns (r:int);
  modifies a, b;
  free ensures R_While3(old(a), a, old(b), b, i, r);

function  CP(a1:mytype, 
             a1':mytype,
	     b1:mytype, 
             b1':mytype, 
             a2:mytype, 
             a2':mytype,
             b2:mytype, 
             b2':mytype):bool
{
    (a1 == a2 && b1 == b2) ==> (a1' == a2' && b1' == b2')
}

 
function  CW12(a1:mytype,
             a1':mytype,
	     b1:mytype,	
             b1':mytype,
             i1:int, r1:int, 
             a2:mytype,
             a2':mytype,
             b2:mytype,
             b2':mytype,
             i2:int, r2:int):bool
{
   ((a1 == a2  && b1 == b2[i2 := S2(a2[i2],b2[i2])] && i1 == i2+1) ==> (a1' == a2' && b1' == b2' && r1 == r2)) 
}

function  CW13(a1:mytype,
             a1':mytype,
	     b1:mytype,	
             b1':mytype,
             i1:int, r1:int, 
             a2:mytype,
             a2':mytype,
             b2:mytype,
             b2':mytype,
             i2:int, r2:int):bool
{
   (b1 == b2 && i1 == i2) ==> (b1' == b2' && r1 == r2)
}

axiom (forall a1:mytype, 
              a1':mytype,
	      b1:mytype, 
              b1':mytype, 
              i1: int, r1: int, 
              a2:mytype, 
              a2':mytype, 
	      b2:mytype, 
              b2':mytype,
              i2: int, r2: int ::
  {R_While1(a1, a1', b1, b1', i1, r1), R_While2(a2, a2', b2, b2', i2, r2)}
   (R_While1(a1, a1', b1, b1', i1, r1) && R_While2(a2, a2', b2, b2', i2, r2)) ==>
    CW12(a1, a1', b1, b1', i1, r1, a2, a2', b2, b2', i2, r2));

axiom (forall a1:mytype, 
              a1':mytype,
	      b1:mytype, 
              b1':mytype, 
              i1: int, r1: int, 
              a2:mytype, 
              a2':mytype, 
	      b2:mytype, 
              b2':mytype,
              i2: int, r2: int ::
  {R_While1(a1, a1', b1, b1', i1, r1), R_While3(a2, a2', b2, b2', i2, r2)}
   R_While1(a1, a1', b1, b1', i1, r1) && R_While3(a2, a2', b2, b2', i2, r2) ==>
    CW13(a1, a1', b1, b1', i1, r1, a2, a2', b2, b2', i2, r2));



axiom (forall a1:mytype, 
              a1':mytype, 
	      b1:mytype, 
              b1':mytype, 
              a2:mytype, 
              a2':mytype,
	      b2:mytype, 
              b2':mytype::
  {R_A(a1,a1',b1,b1'), R_B(a2, a2',b2,b2')}
  R_A(a1,a1',b1,b1') && R_B(a2,a2',b2,b2') ==>
    CP(a1, a1', b1, b1', a2, a2', b2, b2'));


procedure Check_A_B()
   modifies a, b;
{
   var a1: mytype;
   var b1: mytype;
   var a2: mytype;
   var b2: mytype;

   var t:int;
   var i:int;

   call ABody(); 
   a1 := a; b1 := b; havoc a; havoc b; a2 := a; b2 := b;   
   call BBody();
   
   assert CP(old(a), a1, old(b), b1, a2, a, b2, b); 

}


procedure Check_While1_While2(i1:int, i2:int)
   modifies a, b;
{
   var r1:int;
   var r2:int;
   var a1: mytype;
   var b1: mytype;
   var a2: mytype;
   var b2: mytype;
  

   call r1 := While1Body(i1);
   a1 := a; b1 := b; havoc a; havoc b; a2 := a; b2 := b;   	
   call r2 := While2Body(i2);
   
   assert CW12(old(a), a1, old(b), b1, i1, r1, a2, a, b2, b, i2, r2);
}


