/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	Debug_Control	 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	FSMs instances to manage:														*/
/*		a) emips2gdb and ext_control_debug module communication 			*/
/*	   b) TISA registers access													*/
/*		c) memory subsystem access													*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module Debug_Control(

// Input Ports
input clk,
input rst,

input regrdy,					// Signal for TISA GPR write buffer
input fspecial,				// Signal forwarded to registers_fsm 
input valid,					// RS232 incoming Data 
input RnW,						// RnW field
input busy,						// UART busy signal
input end_mem,					// Address counter end_count
input sel_m_byte,				// notify if number of byte to transfert is greater than 31
input suspend_ACK,			// Input from ext_debug_control module
input break,					// Input from ext_debug_control module
input MDATA_VLD,				// Input from TISA memory interface
input [1:0] pclkedge,		// PCLK edge detector signal
input [2:0] opcode,			// opcode field	
input [4:0] options,			// options field

input is_wp, 					// from Debug_dp::wbpoints_dp
input wp_en,

	
// Output Ports

output ld_inreg,				// load data on the Input Register
output fw_shift,				// load bytes on the fullword register
output fw_clr,					// clear fullword register
output TxD_Start,				// Start a UART transmission
output reg_we,					// Registers write enable
output mem_we,					// Memory write enable
output suspend,				// Output to ext_debug_control module
output num_shift,				// eMips num_byte register shift 
output sel_addr,				// eMips mux_addr selector. Select between option field and num_byte reg
output addr_init,				// eMips addr_counter init signal 
output addr_count,			//	eMips add_counter count signal 
output ld_mem_addr,			// To datapath
output MOE,						// To tisa memory interface
output [1:0] sel_out,		// select data that has been requested
output [1:0] sel_byte,		// select full word bytes

output ld_CR, 					// to Debug_dp::wbpoints_dp	
output sh_wp_reg, 					
output ld_wp_type, 
output set_wp_en, 
output rst_wp_en, 
output sel_wp, 
output sel_bp
	

);


// Nets
wire reg_done;
wire mem_done;
wire TxD_Start_main;
wire TxD_Start_reg;
wire TxD_Start_mem;
wire fw_shift_reg;
wire fw_shift_mem;
wire reg_access;				
wire count;
wire count_reg;
wire end_count;
wire init_latency;
wire count_latency; 
wire data_ready;
//wire num_clr;
//wire num_shift;
//wire sel_addr;
//wire addr_init;
//wire addr_count;
//wire end_mem;

// Modules Instances

	// Main FSM
main_fsm FSM_MAIN (
    .clk(clk), 
    .rst(rst), 
    .valid(valid),
	 .busy(busy),	 
    .RnW(RnW), 
    .reg_done(reg_done), 
    .mem_done(mem_done), 
	 .suspend_ACK(suspend_ACK), 
    .break(break), 
    .opcode(opcode), 
	 .options(options),
	 .wp_done(wp_done), 
	 
    .ld_inreg(ld_inreg), 
    .reg_access(reg_access), 
    .mem_access(mem_access), 
    .suspend(suspend), 
    .TxD_Start_main(TxD_Start_main), 
    .sel_out(sel_out),
	 .wp_op(wp_op)
    );

	// Registers FSM
registers_fsm FSM_REG (
	 .clk(clk), 
    .rst(rst), 
    .reg_access(reg_access), 
    .busy(busy),
	 .regrdy(regrdy),
	 .fspecial(fspecial),
    .valid(valid), 
    .RnW(RnW), 
    .end_count(end_count), 
	 .data_ready(data_ready),
	 
    .fw_shift(fw_shift_reg), 
    .fw_clr(fw_clr), 
    .TxD_Start_reg(TxD_Start_reg), 
    .reg_we(reg_we), 
    .reg_done(reg_done), 
    .count_reg(count_reg),
	 .init_latency(init_latency),
	 .count_latency(count_latency)
	);
	  
	 // Mem FSM
memory_fsm FSM_MEMORY (
    .clk(clk), 
    .rst(rst), 
    .mem_access(mem_access), 
    .valid(valid), 
    .busy(busy), 
    .RnW(RnW), 
    .end_mem(end_mem), 
    .sel_m_byte(sel_m_byte), 
    .pclkedge(pclkedge), 
    .MDATA_VLD(MDATA_VLD), 
    .end_count(end_count), 
	 
    .mem_done(mem_done), 
    .TxD_Start_mem(TxD_Start_mem), 
    .num_shift(num_shift), 
    .sel_addr(sel_addr), 
    .addr_init(addr_init), 
    .addr_count(addr_count), 
    .fw_shift_mem(fw_shift_mem), 
	 .ld_mem_addr(ld_mem_addr),
    .MOE(MOE), 
	 .mem_we(mem_we),
    .count_mem(count_mem)
    );

	// wbpoints_fsm
wbpoints_fsm WBPOINTS_FSM (
    .clk(clk), 
    .rst(rst), 
    .valid(valid), 
    .wp_op(wp_op), 
    .is_wp(is_wp), 
    .wp_en(wp_en), 
    .end_count(end_count), 
	 
    .wp_done(wp_done), 
    .ld_CR(ld_CR), 
    .sh_wp_reg(sh_wp_reg), 
    .ld_wp_type(ld_wp_type), 
    .set_wp_en(set_wp_en), 
    .rst_wp_en(rst_wp_en), 
    .sel_wp(sel_wp), 
    .sel_bp(sel_bp), 
    .count_wp(count_wp)
    );

	// Counter
	counter CTRL_COUNTER (
    .clk(clk), 
    .rst(rst), 
    .ce(count), 
    .hit(end_count),
	 .out(sel_byte)
    );
	 
	 // Counter_no_out
	counter_no_out READ_LATENCY_COUNTER (
    .clk(clk), 
    .rst(init_latency), 
    .ce(count_latency), 
    .hit(data_ready)
    );
	 
	 
	// Glue logic 
	assign count = count_reg | count_mem | count_wp; 
	assign fw_shift = fw_shift_reg | fw_shift_mem;
	assign TxD_Start = TxD_Start_main | TxD_Start_reg | TxD_Start_mem; 
	
	
endmodule
