/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	debug_core		 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	emips2gdb communication management, implementation of TISA			*/ 
/*	registers and memory subsystem access protocol							*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module debug_core(

// Input Ports
	//eMips System Signals
input clk,							// System Clock
input pclk,							// pipeline clk
input rst,							// System Reset

	// UART 
input Ready,							// RS232 input Signal
input busy,
input [7:0] Byte_Data,

	// Signals from ext_debug_control
input sel_tisa_pc,
input suspend_ACK,			
input break,		
input [7:0] nAck,			

	// Ext0 Signals
input regrdy,
input MDATA_VLD,
input WE_IN,
input [31:0] from_Regs,			// Databus from eMIPS registers and GPR file
input [31:0] from_PC,			// Databus from PC 
input [31:0] from_Mem,			// Databus from Memory subsystem
input [31:0] MADDR_IN,

// Output Ports
	//	RS232
output TxD_Start,
output [7:0] TxD_Data,

	// ext_debug_control signals
output suspend,				
output [1:0] pclkedge_out,
			

	//	Ext0 Signals
output fspecial,
output Regs_we,					// write enable
output mem_we,
output MOE,

output [4:0] nReg,				// GPR file Address
output [31:0] to_Regs,			// Databus to GPR file
output [31:0] to_PC,
output [31:0] to_Mem_Addr,    // To TISA Memory Subsystem
output [31:0] to_Mem_Data,

output wp_hit, 					// To ext_debug_control::To ext_debug_control_fsm
output bp_hit						// To ext_debug_control::To ext_debug_control_fsm
);

parameter CLKFREQ = 100000000;
parameter BAUD = 115200;

// Nets

wire valid;						
wire ld_inreg;					
wire fw_shift;					
wire fw_clr;														
wire RnW;			
wire reg_we;			
wire num_shift;
wire sel_addr;
wire addr_init;
wire addr_count;
wire end_mem;
wire sel_m_byte;
wire [1:0] sel_out;			
wire [1:0] sel_byte;			
wire [2:0] opcode;	
wire [4:0] options;


	// ValidGen Module
valid_gen VALID_GEN (
    .clk(clk), 
    .rst(rst), 
    .ready(Ready), 
    .valid_r(valid)
    );
	 
	 // Debug Datapath
Debug_dp DEBUG_DP (
    .clk(clk), 
    .pclk(pclk), 
    .rst(rst), 
    .Byte_Data(Byte_Data), 
    .sel_tisa_pc(sel_tisa_pc), 
    .ld_inreg(ld_inreg), 
    .fw_shift(fw_shift), 
    .fw_clr(fw_clr), 
    .reg_we(reg_we), 
	 .num_shift(num_shift),
    .sel_addr(sel_addr),
    .addr_init(addr_init),
    .addr_count(addr_count),
	 .ld_mem_addr(ld_mem_addr),
	 .sel_out(sel_out), 
    .sel_byte(sel_byte), 
    .from_Regs(from_Regs), 
    .from_PC(from_PC), 
    .from_Mem(from_Mem), 
	 .nAck(nAck),
	 .WE_IN(WE_IN),
	 .MADDR_IN(MADDR_IN),
	 .ld_CR(ld_CR), 
	 .sh_wp_reg(sh_wp_reg), 
	 .ld_wp_type(ld_wp_type), 
	 .set_wp_en(set_wp_en), 
	 .rst_wp_en(rst_wp_en), 
	 .sel_wp(sel_wp), 
	 .sel_bp(sel_bp), 
	 
    .TxD_Data(TxD_Data), 
    .fspecial(fspecial), 
    .RnW(RnW), 
    .Regs_we(Regs_we), 
	 .end_mem(end_mem),
    .sel_m_byte(sel_m_byte),
	 .pclkedge_out(pclkedge_out), 
    .opcode(opcode), 
    .nReg(nReg), 
	 .options(options),
    .to_Regs(to_Regs), 
    .to_PC(to_PC), 
    .to_Mem_Addr(to_Mem_Addr), 
    .to_Mem_Data(to_Mem_Data),
	 
	 .is_wp(is_wp), 
	 .wp_en(wp_en), 
	 .wp_hit(wp_hit), 
	 .bp_hit(bp_hit)
    );

	 
	// Debug Control
Debug_Control DEBUG_CONTROL (
    .clk(clk), 
    .rst(rst), 
	 .regrdy(regrdy),
	 .fspecial(fspecial),
    .valid(valid), 
    .RnW(RnW), 
    .busy(busy), 
	 .end_mem(end_mem),
	 .sel_m_byte(sel_m_byte),
    .suspend_ACK(suspend_ACK), 
    .break(break), 
	 .MDATA_VLD(MDATA_VLD),
	 .pclkedge(pclkedge_out),
	 .opcode(opcode), 
	 .options(options),
	 .is_wp(is_wp), 
    .wp_en(wp_en),
	 
    .ld_inreg(ld_inreg), 
    .fw_shift(fw_shift), 
    .fw_clr(fw_clr), 
    .TxD_Start(TxD_Start), 
    .reg_we(reg_we), 
	 .mem_we(mem_we),
    .suspend(suspend), 
	 .num_shift(num_shift),
    .sel_addr(sel_addr),
    .addr_init(addr_init),
    .addr_count(addr_count),
	 .ld_mem_addr(ld_mem_addr),
	 .MOE(MOE),
    .sel_out(sel_out), 
    .sel_byte(sel_byte),
	 .ld_CR(ld_CR), 
    .sh_wp_reg(sh_wp_reg), 
    .ld_wp_type(ld_wp_type), 
    .set_wp_en(set_wp_en), 
    .rst_wp_en(rst_wp_en), 
    .sel_wp(sel_wp), 
    .sel_bp(sel_bp) 
    );
	 
endmodule
