/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	Top_Debug														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This module instances debug datapath, control and uart module		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module Top_Debug(

// Input Ports
	//eMips System Signals
input clk,							// System Clock
input rst,							// System Reset
input pclk,

	// RS232 
input RxD,							// RS232 input Signal

	// from ext_debug_control
input sel_tisa_pc,
input suspend_ACK,				
input break,			
input [7:0] nAck,		
		

	// Ext0 Signals
input regrdy,
input MDATA_VLD,
input WE_IN,
input [31:0] from_Regs,  		// Databus from GPR file and other register except PC
input [31:0] from_PC,			// Databus from PC register 
input [31:0] from_Mem,			// Databus from Memory subsystem
input [31:0] MADDR_IN,


// Output Ports
	//	RS232
output TxD,							// RS232 output Signal

	//	Ext0 Signals
output fspecial,					// 0=GPR access, 1=other eMIPS registers access
output Regs_we,					// eMIPS registers write enable
output mem_we,						// Mem write enable
output MOE,

	// to ext_debug_control 
output suspend,				
output [1:0] pclkedge_out,

output [4:0] nReg,				// Registers Address
output [31:0] to_Regs,			// Databus to GPR file  and other register except PC
output [31:0] to_PC,
output [31:0] to_Mem_Addr,    // To TISA Memory Subsystem
output [31:0] to_Mem_Data,

output wp_hit, 					// To ext_debug_control::To ext_debug_control_fsm 
output bp_hit						// To ext_debug_control::To ext_debug_control_fsm		
	
);

parameter CLKFREQ = 100000000;
parameter BAUD = 115200;

// Nets

	// UART Signals 

wire TxD_Start;
wire Ready;
wire busy;
wire [7:0] TxD_Data, Byte_Data;


//------------------
// Module Instances
//------------------


	// UART Module

uart #(CLKFREQ, BAUD) UART0 (
    .clk(clk), 
    .rst(rst), 
    .RxD(RxD), 
    .TxD_Start(TxD_Start), 
    .TxD_Data(TxD_Data), 
    .TxD(TxD), 
    .Ready(Ready), 
    .busy(busy), 
    .Byte_Data(Byte_Data)
    );

	// Debug Core
debug_core DEBUG_CORE (
    .clk(clk), 
    .pclk(pclk), 
    .rst(rst), 
    .Ready(Ready), 
    .busy(busy), 
    .Byte_Data(Byte_Data), 
    .sel_tisa_pc(sel_tisa_pc), 
    .suspend_ACK(suspend_ACK), 
    .break(break),
	 .nAck(nAck),
	 .regrdy(regrdy),
	 .MDATA_VLD(MDATA_VLD),
    .from_Regs(from_Regs), 
    .from_PC(from_PC), 
    .from_Mem(from_Mem), 
	 .WE_IN(WE_IN),
	 .MADDR_IN(MADDR_IN),
    
	 .TxD_Start(TxD_Start), 
    .TxD_Data(TxD_Data), 
    .suspend(suspend), 
    .pclkedge_out(pclkedge_out), 
    .fspecial(fspecial), 
    .Regs_we(Regs_we), 
    .mem_we(mem_we), 
	 .MOE(MOE),
    .nReg(nReg), 
    .to_Regs(to_Regs), 
    .to_PC(to_PC), 
    .to_Mem_Addr(to_Mem_Addr), 
    .to_Mem_Data(to_Mem_Data),
	 .wp_hit(wp_hit),
	 .bp_hit(bp_hit)	
    );
	 
endmodule
