/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	baud_gen															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	pulse train generator with configurable baud freq.						*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module baud_gen(clk, init_tx, init_rx, en_tx, en_rx, baud_pulse);

parameter CLKFREQ = 100000000;
parameter BAUD = 115200;

parameter MAXCOUNT = (CLKFREQ/BAUD);
parameter RESETVAL = MAXCOUNT/2;

parameter DIM_CNT = 16; 					// Worst case dimension

input clk;									// Clock 
input init_tx;									// Set Counter to 0 
input init_rx;									// Set Counter to half MAXVALUE 
input en_tx;									// enable signal. If asserted pulses are generated
input en_rx;									

output reg baud_pulse;			// Pulse train: period = 1/(2*BAUD)

reg [DIM_CNT-1:0] count = RESETVAL;		// Initialization Safe Value

assign en = en_tx | en_rx;

always @(posedge clk)
if (init_rx || init_tx)
	begin
	count <= init_tx ? 1 : RESETVAL;
	baud_pulse <= 0;
	end
else 
	if (en)
		if (count == MAXCOUNT-1)	
			begin
				count <= 0;
				baud_pulse <= 1;
			end
		else
			begin
				count <= count + 1;
				baud_pulse <= 0;
			end

endmodule
