/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	branch_decoder 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This module recognizes branch, jump and break MIPS instructions	*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

						//SPECIAL  		   CODE		 	 OPCODE//
`define BREAK_OP 32'b000000_xxxxxxxxxxxxxxxxxxxx_001101 

module branch_break_detector(
	input [31:0] instr,
	output is_branch,
	output is_break
);

	reg is_branch_reg;
	reg is_break_reg;
	
// Branch Instr
	always @(instr)

		casex (instr)
			32'b0100_xx01_0000_0xxx_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // BCzF, BCzFL, BCzT, BCzTL
	
			32'b0x01_00xx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // BEQ, BEQL
	
			32'b0000_01xx_xxxx_00xx_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // BEGZ, BEGZAL, BEGZL, BEGZALL, BLTZ, BLTZAL, BLTZALL, BLTZL
			
			32'b0x01_1xxx_xxx0_0000_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // BGTZ, BGTZL, BLEZ, BLEZL
			
			32'b0x01_01xx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // BNE, BNEL
			
			32'b0000_1xxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx : is_branch_reg = 1; // J, JAL
			
			32'b0000_00xx_xxx0_0000_xxxx_x000_0000_1001 : is_branch_reg = 1; // JALR
			
			32'b0000_00xx_xxx0_0000_0000_0000_0000_1000 : is_branch_reg = 1; // JR
		
			default : is_branch_reg = 0;
		endcase

// Break instr
	always @(instr)
		
		casex (instr)
			`BREAK_OP 	: is_break_reg = 1;
			default		: is_break_reg = 0;
		endcase
		
// output assign
		assign is_branch = is_branch_reg;
		assign is_break  = is_break_reg;
endmodule
