/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	counter 			 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This counter is used to pack a 32 bit word in 4 byte stream 		*/
/*	output out is used to drive sel_byte signal in the datapath.  		*/
/*	The hit signal is used to drive end_count signal in registers_fsm */
/*	and memory_fsm																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module counter(
input clk,
input rst, 
input ce, 
output hit,
output [1:0] out
);

reg [1:0] count;

always @(posedge clk)
if (rst) 
	count <= 0;
else if (ce)
		count <= count + 1;

assign hit = count==2'b00;
assign out = count;

endmodule
