/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	counter_no_out	 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This counter is used by the registers_fsm to be compliant with a	*/ 
/*	read access latency to a TISA register.  Parameter READ_LATENCY 	*/
/*	must be set accordingly.														*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module counter_no_out(
input clk,
input rst, 
input ce, 
output hit
);

parameter READ_LATENCY=5;
parameter MAX=(READ_LATENCY>2) ? READ_LATENCY-2 : 0;

reg [1:0] count;

always @(posedge clk)
if (rst) 
	count <= MAX;
else if (ce)
		count <= count - 1 ;

assign hit = count==2'b00;


endmodule
