/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	debug_extension  												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	Top Module of Debug module Extension.  This module instances 		*/
/*	ext_debug_control and Top_Debug modules									*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module debug_extension(

// Input ports
	
	// Input from Extension interface
	input clk, 
	input pclk,
	input rst, 

	input EN,
	input GR,	
	input regrdy,
	input MDATA_VLD,
	input WE_IN,
	input [31:0] INSTR, 
	input [31:0] from_Regs,
	input [31:0] from_PC,
	input [31:0] from_Mem,
	input [31:0] MADDR_IN,
	
	// Input from serial port
	input RxD,

// Output ports
	
	// Output to Extension Interface
	output RI, 
	output ACK,
	
	output fspecial,
	output Regs_we,
	output mem_we,
	output MOE,
	output PCNEXT,
	output [4:0] nReg,
	output [31:0] to_Regs,
	output [31:0] to_PC,
	output [31:0] to_Mem_Addr,
	output [31:0] to_Mem_Data,
	
	// Output to serial port
	output TxD
);

// Bus Connections
wire [1:0] pclkedge_out;
wire [7:0] nAck;

// Debug main module

		Top_Debug DEBUG_MODULE (
			 .clk(clk), 
			 .rst(rst_out), 
			 .pclk(pclk), 
			 .RxD(RxD), 
			 .sel_tisa_pc(sel_tisa_pc), 
			 .suspend_ACK(suspend_ACK), 
			 .break(break),
			 .nAck(nAck),
			 .regrdy(regrdy),
			 .MDATA_VLD(MDATA_VLD),
			 .from_Regs(from_Regs), 
			 .from_PC(from_PC), 
			 .from_Mem(from_Mem), 
			 .WE_IN(WE_IN),
			 .MADDR_IN(MADDR_IN),
			 
			 .TxD(TxD), 
			 .fspecial(fspecial), 
			 .Regs_we(Regs_we), 
			 .mem_we(mem_we), 
			 .MOE(MOE),
			 .suspend(suspend), 
			 .pclkedge_out(pclkedge_out), 
			 .nReg(nReg), 
			 .to_Regs(to_Regs), 
			 .to_PC(to_PC), 
			 .to_Mem_Addr(to_Mem_Addr), 
			 .to_Mem_Data(to_Mem_Data),
			 .wp_hit(wp_hit),
			 .bp_hit(bp_hit)	
			 );


 
// Extension Tisa handshake controller
		ext_debug_control DEBUG_EXT_CONTROL (
			 .clk(clk), 
			 .rst(rst_out), 
			 .EN(EN), 
			 .GR(GR), 
			 .INSTR(INSTR), 
			 .suspend(suspend), 
			 .pclkedge(pclkedge_out), 
			 .wp_hit(wp_hit),
			 .bp_hit(bp_hit),	
			 
			 .break(break), 
			 .sel_tisa_pc(sel_tisa_pc), 
			 .suspend_ACK(suspend_ACK),
			 .nAck(nAck),
			 .RI(RI), 
			 .ACK(ACK),
			 .PCNEXT(PCNEXT)
			 );


// Reset Manager
		reset_manager RST_MANAGER (
			 //.clk(clk), 
			 .rst_in(rst), 
			 .rst_out(rst_out)
			 );

endmodule
