/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	decoder			 												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	decoder_sel_reg is used to select the source of a register read.	*/
/*	If the read involved the PC, its value is taken from the PC_Break	*/
/*	register in the datapath. All the other register are taken from	*/
/*	the TISA decoder_sel_m_byte is used to select the source where is	*/
/*	stored the number of byte involved in a memory transaction			*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

// Registers side decoder

	module decoder_sel_reg(
		input fspecial,
		input reg_we,
		input [2:0] fspecial_num,
		
		output reg Regs_we,
		output reg PC_we,
		output reg sel_reg
		);
		
		always @(fspecial, reg_we, fspecial_num)
		if (fspecial && (fspecial_num == 3'b000))		// PC access
			begin
				sel_reg  = 1'b1;
				Regs_we  = 1'b0;
				PC_we    = reg_we;
			end
		else 														// GPR file or Registers access
			begin
				sel_reg  = 1'b0;
				Regs_we  = reg_we;
				PC_we    = 1'b0;
			end
			
	endmodule
	
// Mem side decoder

	module decoder_sel_m_byte (
		input [4:0] options,
		output sel_m_byte
		);
		
		assign sel_m_byte = (options == 0); 
	endmodule
