/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	decoder_wp_cnt													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 2									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module decoder_wp_cnt(
	
	input sh_wp_reg,		
	input ld_wp_type,	
	input set_wp_en,
	input rst_wp_en,
	input sel_wp,
	input sel_bp,
	input [3:0] wp_num,
	
	
	output reg sh_wp_reg_0,		
	output reg ld_wp_type_0,	
	output reg set_wp_en_0,
	output reg rst_wp_en_0,
	output reg sel_wp_0,
	output reg sel_bp_0,
	
	output reg sh_wp_reg_1,		
	output reg ld_wp_type_1,	
	output reg set_wp_en_1,
	output reg rst_wp_en_1,
	output reg sel_wp_1,
	output reg sel_bp_1
	
 	);
	
always @(wp_num, sh_wp_reg, ld_wp_type, set_wp_en, rst_wp_en, sel_wp, sel_bp)
	begin 
		sh_wp_reg_0 	= 0;		
		ld_wp_type_0 	= 0;
		set_wp_en_0		= 0;
		rst_wp_en_0 	= 0;
		sel_wp_0			= 0;
		sel_bp_0			= 0;
				
		sh_wp_reg_1 	= 0;		
		ld_wp_type_1 	= 0;
		set_wp_en_1		= 0;
		rst_wp_en_1 	= 0;
		sel_wp_1			= 0;
		sel_bp_1			= 0;
		
		case (wp_num)
			5'd0: begin
						sh_wp_reg_0 	= sh_wp_reg;		
						ld_wp_type_0 	= ld_wp_type;
						set_wp_en_0		= set_wp_en;
						rst_wp_en_0 	= rst_wp_en;
						sel_wp_0			= sel_wp;
						sel_bp_0			= sel_bp;
					end
	
			5'd1: begin
						sh_wp_reg_1 	= sh_wp_reg;		
						ld_wp_type_1 	= ld_wp_type;
						set_wp_en_1		= set_wp_en;
						rst_wp_en_1 	= rst_wp_en;
						sel_wp_1			= sel_wp;
						sel_bp_1			= sel_bp;
					end
		endcase
	end
	
endmodule
