/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	wbpoints_dp														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 2									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module wbpoints_dp(
	input clk,
	input rst,
	
	input ld_CR,
	input sh_wp_reg,		
	input ld_wp_type,	
	input set_wp_en,
	input rst_wp_en,
	input sel_wp,
	input sel_bp,
	
	input WE_IN,
	input [7:0] Byte_Data,
	input [31:0] MADDR_IN,
	input [31:0] PC,
	
	output is_wp,
	output wp_en,
	
	output wp_hit,
	output bp_hit
	);
	
	reg [7:0] CR; 		// Control Register
	
	wire [1:0] wp_type;
	wire [3:0] wp_num;
	
	// CR FIELDS
	assign wp_num 	= CR [3:0];
	assign wp_en  	= CR [5];
	assign is_wp 	= CR [4];
	assign wp_type = CR [7:6];
	
	
	// INSTANCES OF WATCHPOINT BASIC ELEMENTS
	wp_bel WP_0 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_0), 
		 .ld_wp_type(ld_wp_type_0), 
		 .set_wp_en(set_wp_en_0), 
		 .rst_wp_en(rst_wp_en_0), 
		 .sel_wp(sel_wp_0),
		 .sel_bp(sel_bp_0),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_0),
		 .bp_hit(bp_hit_0)
		 );
	
	wp_bel WP_1 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_1), 
		 .ld_wp_type(ld_wp_type_1), 
		 .set_wp_en(set_wp_en_1), 
		 .rst_wp_en(rst_wp_en_1), 
		 .sel_wp(sel_wp_1),
		 .sel_bp(sel_bp_1),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_1),
		 .bp_hit(bp_hit_1)
		 );
	
	// Decoder for control signals
	decoder_wp_cnt DEC_WP_CNT  (
		 .sh_wp_reg(sh_wp_reg), 
		 .ld_wp_type(ld_wp_type), 
		 .set_wp_en(set_wp_en), 
		 .rst_wp_en(rst_wp_en), 
		 .sel_wp(sel_wp), 
		 .sel_bp(sel_bp), 
		 .wp_num(wp_num), 
		 
		 .sh_wp_reg_0(sh_wp_reg_0), 
		 .ld_wp_type_0(ld_wp_type_0), 
		 .set_wp_en_0(set_wp_en_0), 
		 .rst_wp_en_0(rst_wp_en_0), 
		 .sel_wp_0(sel_wp_0), 
		 .sel_bp_0(sel_bp_0), 
		 
		 .sh_wp_reg_1(sh_wp_reg_1), 
		 .ld_wp_type_1(ld_wp_type_1), 
		 .set_wp_en_1(set_wp_en_1), 
		 .rst_wp_en_1(rst_wp_en_1), 
		 .sel_wp_1(sel_wp_1), 
		 .sel_bp_1(sel_bp_1)
		 );
	
	// Control Register
	always @(posedge clk)
		if (ld_CR)
			CR <= Byte_Data;
	
	// Output logic 
		assign wp_hit = wp_hit_0 | wp_hit_1;
		assign bp_hit = bp_hit_0 | bp_hit_1;
		
endmodule
