/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	wbpoints_fsm													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 2									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module wbpoints_fsm(

	input clk,
	input rst,
	
	// Input from UART
	input valid,
	// Inputs from main_fsm
	input wp_op,
	// Inputs from datapath
	input is_wp,
	input wp_en,
	// Inputs from counter
	input end_count,
	
	// outputs to main_fsm
	output wp_done,
	// outputs to datapath
	output ld_CR,
	output sh_wp_reg,
	output ld_wp_type,
	output set_wp_en,
	output rst_wp_en,
	output sel_wp, 
	output sel_bp,
	
	// outputs to counter
	output count_wp
	);
	
	parameter IDLE=0, WAIT_CR=1, STORE_CR=2, CHECK_WP=3, COUNT=4, WAIT_BYTE=5, SH_WP_REG=6,
				 EN_STO_TYPE=7, WP_DISABLE=8, SET_BP=9, SET_WP=10;
	
	reg [3:0] cs, ns;
	reg [8:0] moore_out;
	
// Current State Refresh
	always @(posedge clk)
		if (rst)
			cs <= IDLE;
		else
			cs <= ns;

// Next State logic
	always @(cs, valid, wp_op, is_wp, wp_en, end_count)
		case (cs)
			IDLE				:	if (wp_op)
										ns = WAIT_CR;
									else 
										ns = IDLE;
			
			WAIT_CR			:	if (valid)
										ns = STORE_CR;
									else
										ns = WAIT_CR;
			
			STORE_CR			:	ns = CHECK_WP;
			
			CHECK_WP			:	if (is_wp)
										ns = SET_WP;
									else 
										ns = SET_BP;
			
			SET_BP			:	if (wp_en)
										ns = COUNT;
									else 
										ns = WP_DISABLE;
						
			SET_WP			:	if (wp_en)
										ns = COUNT;
									else 
										ns = WP_DISABLE;
			
			COUNT				:	ns = WAIT_BYTE;
			
			WAIT_BYTE		:	if (valid)
										ns = SH_WP_REG;
									else
										ns = WAIT_BYTE;
			
			SH_WP_REG 		:	if (end_count)
										ns = EN_STO_TYPE;
									else 
										ns = COUNT;
			
			EN_STO_TYPE		: 	ns = IDLE;
			
			WP_DISABLE		:	ns = IDLE;
			
			default 			:	ns = IDLE;
		endcase
	
// Output logic
	
	assign {wp_done, ld_CR, sh_wp_reg, ld_wp_type, set_wp_en, rst_wp_en, count_wp, sel_wp, sel_bp} = moore_out;
	
	always @(cs)
		case (cs)
			IDLE				: moore_out = 9'b100000000;
			WAIT_CR			: moore_out = 9'b000000000;
			STORE_CR			: moore_out = 9'b010000000;
			CHECK_WP			: moore_out = 9'b000000000;
			SET_BP			: moore_out = 9'b000000001;
			SET_WP			: moore_out = 9'b000000010;		
			COUNT				: moore_out = 9'b000000100;
			WAIT_BYTE		: moore_out = 9'b000000000;
			SH_WP_REG 		: moore_out = 9'b001000000;
			EN_STO_TYPE		: moore_out = 9'b000110000;
			WP_DISABLE		: moore_out = 9'b000001000;			 
			default 			: moore_out = 9'b100000000;
		endcase
	


endmodule
