/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	wp_bel															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 2									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module wp_bel(
	input clk,
	input rst,
	
	input sh_wp_reg,
	input ld_wp_type,
	input set_wp_en,
	input rst_wp_en,
	input sel_wp,
	input sel_bp,
	
	input WE_IN,
	input [1:0] wp_type_in,
	input [7:0] wp_reg_in,
	input [31:0] MADDR_IN,
	input [31:0] PC,
	
	output wp_hit,
	output bp_hit
	);


	reg wp_en_logic;
	reg bp_en_logic;
	
	reg en_reg;
	reg sel_addr_reg;
	reg [1:0] wp_type_reg;
	reg [31:0] wp_reg;
	
	wire [31:0] mux_out;
	
	assign write_en = WE_IN;
	
// Regs
	
	// wp_en_reg
	always @(posedge clk)
		if (rst) 
			en_reg <= 0;
		else if (set_wp_en)
					en_reg <= 1;
				else if (rst_wp_en)
							en_reg <= 0;
	
	// sel_addr_reg
	always @(posedge clk)
		if (rst) 
			sel_addr_reg <= 0;
		else if (sel_wp)
					sel_addr_reg <= 1;
				else if (sel_bp)
							sel_addr_reg <= 0;
				
				
	// wp_type_reg
	always @(posedge clk)
		if (ld_wp_type)
			wp_type_reg <= wp_type_in;
	
	// wp_reg
	always @(posedge clk)
		if (sh_wp_reg)
			wp_reg <= {wp_reg[23:0], wp_reg_in};
	
	
// Output logic
	// Mux
	assign mux_out = sel_addr_reg ? MADDR_IN : PC;
	
	// Address comparator
	assign address_match = wp_reg == mux_out;
	
	// watchpoint enable logic
	always @(en_reg, wp_type_reg, write_en, sel_addr_reg)
		casex ({en_reg, wp_type_reg, write_en, sel_addr_reg})
			5'b0xxx1	:	wp_en_logic = 1'b0;
			5'b10001	:	wp_en_logic = 1'b0;
			5'b10011	:	wp_en_logic = 1'b1;
			5'b10101	:	wp_en_logic = 1'b1;
			5'b10111	:	wp_en_logic = 1'b0;
			5'b11001	:	wp_en_logic = 1'b1;
			5'b11011	:	wp_en_logic = 1'b1;
			default 	:  wp_en_logic = 1'b0;
		endcase

	// breakpoint enable logic
	always @(en_reg, sel_addr_reg)
		casex ({en_reg, sel_addr_reg})
			2'b00		:	bp_en_logic = 1'b0;
			2'b10		:	bp_en_logic = 1'b1;
			default 	:  bp_en_logic = 1'b0;
		endcase
		
		
	// output 
	
	assign wp_hit = address_match & wp_en_logic;
	assign bp_hit = address_match & bp_en_logic;
	
endmodule
