/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	decoder_wp_cnt													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 8									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module decoder_wp_cnt(
	
	input sh_wp_reg,		
	input ld_wp_type,	
	input set_wp_en,
	input rst_wp_en,
	input sel_wp,
	input sel_bp,
	input [3:0] wp_num,
	
	
	output reg sh_wp_reg_0,		
	output reg ld_wp_type_0,	
	output reg set_wp_en_0,
	output reg rst_wp_en_0,
	output reg sel_wp_0,
	output reg sel_bp_0,
	
	output reg sh_wp_reg_1,		
	output reg ld_wp_type_1,	
	output reg set_wp_en_1,
	output reg rst_wp_en_1,
	output reg sel_wp_1,
	output reg sel_bp_1,
	
	output reg sh_wp_reg_2,		
	output reg ld_wp_type_2,	
	output reg set_wp_en_2,
	output reg rst_wp_en_2,
	output reg sel_wp_2,
	output reg sel_bp_2,
	
	output reg sh_wp_reg_3,		
	output reg ld_wp_type_3,	
	output reg set_wp_en_3,
	output reg rst_wp_en_3,
	output reg sel_wp_3,
	output reg sel_bp_3,
	
	output reg sh_wp_reg_4,		
	output reg ld_wp_type_4,	
	output reg set_wp_en_4,
	output reg rst_wp_en_4,
	output reg sel_wp_4,
	output reg sel_bp_4,
	
	output reg sh_wp_reg_5,		
	output reg ld_wp_type_5,	
	output reg set_wp_en_5,
	output reg rst_wp_en_5,
	output reg sel_wp_5,
	output reg sel_bp_5,
	
	output reg sh_wp_reg_6,		
	output reg ld_wp_type_6,	
	output reg set_wp_en_6,
	output reg rst_wp_en_6,
	output reg sel_wp_6,
	output reg sel_bp_6,
	
	output reg sh_wp_reg_7,		
	output reg ld_wp_type_7,	
	output reg set_wp_en_7,
	output reg rst_wp_en_7,
	output reg sel_wp_7,
	output reg sel_bp_7
	
 	);
	
always @(wp_num, sh_wp_reg, ld_wp_type, set_wp_en, rst_wp_en, sel_wp, sel_bp)
	begin 
		sh_wp_reg_0 	= 0;		
		ld_wp_type_0 	= 0;
		set_wp_en_0		= 0;
		rst_wp_en_0 	= 0;
		sel_wp_0			= 0;
		sel_bp_0			= 0;
				
		sh_wp_reg_1 	= 0;		
		ld_wp_type_1 	= 0;
		set_wp_en_1		= 0;
		rst_wp_en_1 	= 0;
		sel_wp_1			= 0;
		sel_bp_1			= 0;
		
		sh_wp_reg_2 	= 0;		
		ld_wp_type_2 	= 0;
		set_wp_en_2		= 0;
		rst_wp_en_2 	= 0;
		sel_wp_2			= 0;
		sel_bp_2			= 0;
		
		sh_wp_reg_3 	= 0;		
		ld_wp_type_3 	= 0;
		set_wp_en_3		= 0;
		rst_wp_en_3 	= 0;
		sel_wp_3			= 0;
		sel_bp_3			= 0;
		
		sh_wp_reg_4 	= 0;		
		ld_wp_type_4 	= 0;
		set_wp_en_4		= 0;
		rst_wp_en_4 	= 0;
		sel_wp_4			= 0;
		sel_bp_4			= 0;
				
		sh_wp_reg_5 	= 0;		
		ld_wp_type_5 	= 0;
		set_wp_en_5		= 0;
		rst_wp_en_5 	= 0;
		sel_wp_5			= 0;
		sel_bp_5			= 0;
		
		sh_wp_reg_6 	= 0;		
		ld_wp_type_6 	= 0;
		set_wp_en_6		= 0;
		rst_wp_en_6 	= 0;
		sel_wp_6			= 0;
		sel_bp_6			= 0;
		
		sh_wp_reg_7 	= 0;		
		ld_wp_type_7 	= 0;
		set_wp_en_7		= 0;
		rst_wp_en_7 	= 0;
		sel_wp_7			= 0;
		sel_bp_7			= 0;
		
		case (wp_num)
			5'd0: begin
						sh_wp_reg_0 	= sh_wp_reg;		
						ld_wp_type_0 	= ld_wp_type;
						set_wp_en_0		= set_wp_en;
						rst_wp_en_0 	= rst_wp_en;
						sel_wp_0			= sel_wp;
						sel_bp_0			= sel_bp;
					end
	
			5'd1: begin
						sh_wp_reg_1 	= sh_wp_reg;		
						ld_wp_type_1 	= ld_wp_type;
						set_wp_en_1		= set_wp_en;
						rst_wp_en_1 	= rst_wp_en;
						sel_wp_1			= sel_wp;
						sel_bp_1			= sel_bp;
					end
					
			5'd2: begin
						sh_wp_reg_2 	= sh_wp_reg;		
						ld_wp_type_2 	= ld_wp_type;
						set_wp_en_2		= set_wp_en;
						rst_wp_en_2 	= rst_wp_en;
						sel_wp_2			= sel_wp;
						sel_bp_2			= sel_bp;
					end
	
			5'd3: begin
						sh_wp_reg_3 	= sh_wp_reg;		
						ld_wp_type_3 	= ld_wp_type;
						set_wp_en_3		= set_wp_en;
						rst_wp_en_3 	= rst_wp_en;
						sel_wp_3			= sel_wp;
						sel_bp_3			= sel_bp;
					end
					
			5'd4: begin
						sh_wp_reg_4 	= sh_wp_reg;		
						ld_wp_type_4 	= ld_wp_type;
						set_wp_en_4		= set_wp_en;
						rst_wp_en_4 	= rst_wp_en;
						sel_wp_4			= sel_wp;
						sel_bp_4			= sel_bp;
					end
	
			5'd5: begin
						sh_wp_reg_5 	= sh_wp_reg;		
						ld_wp_type_5 	= ld_wp_type;
						set_wp_en_5		= set_wp_en;
						rst_wp_en_5 	= rst_wp_en;
						sel_wp_5			= sel_wp;
						sel_bp_5			= sel_bp;
					end
					
			5'd6: begin
						sh_wp_reg_6 	= sh_wp_reg;		
						ld_wp_type_6 	= ld_wp_type;
						set_wp_en_6		= set_wp_en;
						rst_wp_en_6 	= rst_wp_en;
						sel_wp_6			= sel_wp;
						sel_bp_6			= sel_bp;
					end
	
			5'd7: begin
						sh_wp_reg_7 	= sh_wp_reg;		
						ld_wp_type_7 	= ld_wp_type;
						set_wp_en_7		= set_wp_en;
						rst_wp_en_7 	= rst_wp_en;
						sel_wp_7			= sel_wp;
						sel_bp_7			= sel_bp;
					end
		endcase
	end
	
endmodule
