/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	wbpoints_dp														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP 8									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module wbpoints_dp(
	input clk,
	input rst,
	
	input ld_CR,
	input sh_wp_reg,		
	input ld_wp_type,	
	input set_wp_en,
	input rst_wp_en,
	input sel_wp,
	input sel_bp,
	
	input WE_IN,
	input [7:0] Byte_Data,
	input [31:0] MADDR_IN,
	input [31:0] PC,
	
	output is_wp,
	output wp_en,
	
	output wp_hit,
	output bp_hit
	);
	
	reg [7:0] CR; 		// Control Register
	
	wire [1:0] wp_type;
	wire [3:0] wp_num;
	
	// CR FIELDS
	assign wp_num 	= CR [3:0];
	assign wp_en  	= CR [5];
	assign is_wp 	= CR [4];
	assign wp_type = CR [7:6];
	
	
	// INSTANCES OF WATCHPOINT BASIC ELEMENTS
	wp_bel WP_0 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_0), 
		 .ld_wp_type(ld_wp_type_0), 
		 .set_wp_en(set_wp_en_0), 
		 .rst_wp_en(rst_wp_en_0), 
		 .sel_wp(sel_wp_0),
		 .sel_bp(sel_bp_0),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_0),
		 .bp_hit(bp_hit_0)
		 );
	
	wp_bel WP_1 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_1), 
		 .ld_wp_type(ld_wp_type_1), 
		 .set_wp_en(set_wp_en_1), 
		 .rst_wp_en(rst_wp_en_1), 
		 .sel_wp(sel_wp_1),
		 .sel_bp(sel_bp_1),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_1),
		 .bp_hit(bp_hit_1)
		 );

	wp_bel WP_2 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_2), 
		 .ld_wp_type(ld_wp_type_2), 
		 .set_wp_en(set_wp_en_2), 
		 .rst_wp_en(rst_wp_en_2), 
		 .sel_wp(sel_wp_2),
		 .sel_bp(sel_bp_2),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_2),
		 .bp_hit(bp_hit_2)
		 );
	
	wp_bel WP_3 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_3), 
		 .ld_wp_type(ld_wp_type_3), 
		 .set_wp_en(set_wp_en_3), 
		 .rst_wp_en(rst_wp_en_3), 
		 .sel_wp(sel_wp_3),
		 .sel_bp(sel_bp_3),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_3),
		 .bp_hit(bp_hit_3)
		 );
		 
	wp_bel WP_4 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_4), 
		 .ld_wp_type(ld_wp_type_4), 
		 .set_wp_en(set_wp_en_4), 
		 .rst_wp_en(rst_wp_en_4), 
		 .sel_wp(sel_wp_4),
		 .sel_bp(sel_bp_4),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_4),
		 .bp_hit(bp_hit_4)
		 );
	
	wp_bel WP_5 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_5), 
		 .ld_wp_type(ld_wp_type_5), 
		 .set_wp_en(set_wp_en_5), 
		 .rst_wp_en(rst_wp_en_5), 
		 .sel_wp(sel_wp_5),
		 .sel_bp(sel_bp_5),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_5),
		 .bp_hit(bp_hit_5)
		 );

	wp_bel WP_6 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_6), 
		 .ld_wp_type(ld_wp_type_6), 
		 .set_wp_en(set_wp_en_6), 
		 .rst_wp_en(rst_wp_en_6), 
		 .sel_wp(sel_wp_6),
		 .sel_bp(sel_bp_6),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_6),
		 .bp_hit(bp_hit_6)
		 );
	
	wp_bel WP_7 (
		 .clk(clk), 
		 .rst(rst), 
		 .sh_wp_reg(sh_wp_reg_7), 
		 .ld_wp_type(ld_wp_type_7), 
		 .set_wp_en(set_wp_en_7), 
		 .rst_wp_en(rst_wp_en_7), 
		 .sel_wp(sel_wp_7),
		 .sel_bp(sel_bp_7),
		 .WE_IN(WE_IN), 
		 .wp_type_in(wp_type), 
		 .wp_reg_in(Byte_Data), 
		 .MADDR_IN(MADDR_IN), 
		 .PC(PC),
		 
		 .wp_hit(wp_hit_7),
		 .bp_hit(bp_hit_7)
		 );
	// Decoder for control signals
	decoder_wp_cnt DEC_WP_CNT  (
    .sh_wp_reg(sh_wp_reg), 
    .ld_wp_type(ld_wp_type), 
    .set_wp_en(set_wp_en), 
    .rst_wp_en(rst_wp_en), 
    .sel_wp(sel_wp), 
    .sel_bp(sel_bp), 
    .wp_num(wp_num), 
	 
    .sh_wp_reg_0(sh_wp_reg_0), 
    .ld_wp_type_0(ld_wp_type_0), 
    .set_wp_en_0(set_wp_en_0), 
    .rst_wp_en_0(rst_wp_en_0), 
    .sel_wp_0(sel_wp_0), 
    .sel_bp_0(sel_bp_0), 
	 
    .sh_wp_reg_1(sh_wp_reg_1), 
    .ld_wp_type_1(ld_wp_type_1), 
    .set_wp_en_1(set_wp_en_1), 
    .rst_wp_en_1(rst_wp_en_1), 
    .sel_wp_1(sel_wp_1), 
    .sel_bp_1(sel_bp_1), 
	 
    .sh_wp_reg_2(sh_wp_reg_2), 
    .ld_wp_type_2(ld_wp_type_2), 
    .set_wp_en_2(set_wp_en_2), 
    .rst_wp_en_2(rst_wp_en_2), 
    .sel_wp_2(sel_wp_2), 
    .sel_bp_2(sel_bp_2), 
	 
    .sh_wp_reg_3(sh_wp_reg_3), 
    .ld_wp_type_3(ld_wp_type_3), 
    .set_wp_en_3(set_wp_en_3), 
    .rst_wp_en_3(rst_wp_en_3), 
    .sel_wp_3(sel_wp_3), 
    .sel_bp_3(sel_bp_3), 
	 
    .sh_wp_reg_4(sh_wp_reg_4), 
    .ld_wp_type_4(ld_wp_type_4), 
    .set_wp_en_4(set_wp_en_4), 
    .rst_wp_en_4(rst_wp_en_4), 
    .sel_wp_4(sel_wp_4), 
    .sel_bp_4(sel_bp_4), 
	 
    .sh_wp_reg_5(sh_wp_reg_5), 
    .ld_wp_type_5(ld_wp_type_5), 
    .set_wp_en_5(set_wp_en_5), 
    .rst_wp_en_5(rst_wp_en_5), 
    .sel_wp_5(sel_wp_5), 
    .sel_bp_5(sel_bp_5), 
	 
    .sh_wp_reg_6(sh_wp_reg_6), 
    .ld_wp_type_6(ld_wp_type_6), 
    .set_wp_en_6(set_wp_en_6), 
    .rst_wp_en_6(rst_wp_en_6), 
    .sel_wp_6(sel_wp_6), 
    .sel_bp_6(sel_bp_6), 
	 
    .sh_wp_reg_7(sh_wp_reg_7), 
    .ld_wp_type_7(ld_wp_type_7), 
    .set_wp_en_7(set_wp_en_7), 
    .rst_wp_en_7(rst_wp_en_7), 
    .sel_wp_7(sel_wp_7), 
    .sel_bp_7(sel_bp_7)
    );
	
	// Control Register
	always @(posedge clk)
		if (ld_CR)
			CR <= Byte_Data;
	
	// Output logic 
		assign wp_hit = wp_hit_0 | wp_hit_1 | wp_hit_2 | wp_hit_3 |
							 wp_hit_4 | wp_hit_5 | wp_hit_6 | wp_hit_7;
		assign bp_hit = bp_hit_0 | bp_hit_1 | bp_hit_2 | bp_hit_3 |
							 bp_hit_4 | bp_hit_5 | bp_hit_6 | bp_hit_7;
		
endmodule
