/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	nAck_generator													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This module is used to generate multiple value for nAck signal		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

`define GDB_BREAKPOINT		20'h01400
`define LOAD_EXT_BREAK		20'h00400
`define UNLOAD_EXT_BREAK   20'h00800

module nAck_generator(
	input [19:0]break_code,
	input is_break,
	
	output reg [7:0] nAck
 );


always @(break_code, is_break)
	if (is_break)
		case (break_code)
			`GDB_BREAKPOINT	: nAck = 8'h00;
			`LOAD_EXT_BREAK	: nAck = 8'h01;		
			`UNLOAD_EXT_BREAK	: nAck = 8'h02;
			default				: nAck = 8'h03;
		endcase
	else 
		nAck = 8'h00;
		
endmodule
