/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	valid_gen														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	This modules generates a pulse everytime a byte is incoming from 	*/
/* serial line																			*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	eBug Extension, HW WP									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module valid_gen(clk, rst, ready, valid_r);

parameter IDLE=0, WAIT=1;

input clk;
input rst;
input ready;

output reg valid_r;

reg cs, ns;
reg valid;


always @(posedge clk)
if (rst)
	cs <= IDLE;
else
	cs <= ns;
	
always @(cs, ready)
case (cs)
	IDLE 		: if (~ready) 
						begin ns = WAIT; valid = 0; end
				  else
						begin ns = IDLE; valid = 0; end
	WAIT		: if (~ready) 
						begin ns = WAIT; valid = 0; end
				  else
						begin ns = IDLE; valid = 1; end
						
	default  : 	begin ns = WAIT; valid = 0; end
endcase

// Output registred
always @(posedge clk)
	valid_r <= valid;

endmodule
