/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* File Name:		decode															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

/*****Op Codes****************************************************************/

`define	J			6'b000010	/*	02	jump */
`define	JAL		6'b000011	/*	03	jump and link */
`define	BEQ		6'b000100	/*	04	branch if equal */
`define	BNE		6'b000101	/*	05	branch if not equal */
`define	BLEZ		6'b000110	/*	06	branch on less than or equal to zero */
`define	BGTZ		6'b000111	/*	07	branch on greater than zero */
`define	ADDI		6'b001000	/*	08	add immediate word */
`define	ADDIU		6'b001001	/*	09	add immediate unsigned word */
`define	SLTI		6'b001010	/*	10	set on less than immediate */
`define	SLTIU		6'b001011	/*	11	set on less than immediate unsigned */
`define	ANDI		6'b001100	/*	12	and immediate */
`define	ORI		6'b001101	/*	13	or immediate */
`define	XORI		6'b001110	/*	14	xor immediate */
`define	LUI		6'b001111	/*	15	load upper immediate */
`define	BEQL		6'b010100	/*	20	branch if eqaul likely */
`define	BNEL		6'b010101	/*	21	branch if not equal likely */
`define	BLEZL		6'b010110	/*	22	branch on less than or equal to zero likely */
`define	BGTZL		6'b010111	/*	23	branch on greater than zero likely */
`define	LB			6'b100000	/*	32	load byte */
`define	LH			6'b100001	/*	33	load halfword */
`define	LWL		6'b100010	/*	34	load word left */
`define	LW			6'b100011	/*	35	load word */
`define	LBU		6'b100100	/*	36	load byte unsiged */
`define	LHU		6'b100101	/*	37	load halfword unsigned */
`define	LWR		6'b100110	/*	38	load word right */
`define	LWU		6'b100111	/*	39	load word unsigned */
`define	SB			6'b101000	/*	40	store byte */
`define	SH			6'b101001	/*	41	store halfword */
`define	SWL		6'b101010	/*	42	store word left */
`define	SW			6'b101011	/*	43	store word */
`define	SWR		6'b101110	/*	44	store word right */
`define	LL			6'b110000	/*	48 load linked word */
`define	SC			6'b111000	/*	56	store conditional word */

`define	SPEC		6'b000000	/*	00	arithmetic operation */
`define	BCOND		6'b000001	/*	01	biconditional */
`define	COP0		6'b010000	/*	16 Coprocessor 0 (System Coprocessor) */

/* SPEC OP CODES (OPCODE == SPEC) */
`define	NOP		6'b000000	/*	00	do nothing */
`define	SLL		6'b000000	/*	00	shift left logical */
`define	SRL		6'b000010	/*	02	shift right logical */
`define	SRA		6'b000011	/*	03	shift right arithmatic */
`define	SLLV		6'b000100	/*	04	shift left logical */
`define	SRLV		6'b000110	/*	06	shift right logical */
`define	SRAV		6'b000111	/*	07	shift right arithmatic */
`define	JR			6'b001000	/*	08	jump registered */
`define	JALR		6'b001001	/*	09	jump and link registered */
`define	MOVZ		6'b001010	/*	10	move on zero */
`define	MOVN		6'b001011	/*	11	move on not zero */
`define	SYSCALL	6'b001100	/*	12	system call */
`define	BREAK		6'b001101	/*	13	breakpoint */
`define	MFHI		6'b010000	/*	16	copy from HIGH to GPR */
`define	MFLO		6'b010010	/*	18	copy from LOW  to GPR */
`define	MTHI		6'b010001	/*	17 copy from GPR to HIGH */
`define	MTLO		6'b010011	/*	19	copy from GPR to LOW */
`define	MULT		6'b011000	/*	24	multipy word */
`define	MULTU		6'b011001	/*	25	multipy unsigned word */
`define	DIV		6'b011010	/*	26	divide word */
`define	DIVU		6'b011011	/*	27	divide unsigned word */ 
`define	ADD		6'b100000	/*	32	2's compl add */ 
`define	ADDU		6'b100001	/*	33	unsigned add */ 
`define	SUB		6'b100010	/*	34	2's compl subtract */
`define	SUBU		6'b100011	/*	35	unsigned subtract */
`define	AND		6'b100100	/*	36	bitwise AND */
`define	OR			6'b100101	/*	37	bitwise OR */
`define	XOR		6'b100110	/*	38	bitwise XOR */
`define	SLT		6'b101010	/*	42	set result=1 if less than 2's compl */
`define	SLTU		6'b101011	/*	43	set result=1 if less than unsigned */
`define	NOR		6'b100111	/*	39	bitwise NOR */
`define	TGE		6'b110000	/*	48	trap if greater or equal */
`define	TGEU		6'b110001	/*	49	trap if greater or equal unsigned */
`define	TLT		6'b110010	/*	50	trap if less than */
`define	TLTU		6'b110011	/*	51	trap if less than unsigned */
`define	TEQ		6'b110100	/*	52	trap if equal */
`define	TNE		6'b110110	/*	54	trap if not equal */

/* Biconditional OP CODES (OPCODE == BCOND) */
`define	BLTZ		5'b00000		/*	00	branch on less than zero */
`define	BGEZ		5'b00001		/*	01	branch on greater than or equal to zero */
`define	BLTZL		5'b00010		/*	02	branch on less than zero likely */
`define	BGEZL		5'b00011		/*	03	branch on greater than or equal to zero likely */
`define	TGEI		5'b01000		/*	08	trap if greater or equal immediate */
`define	TGEIU		5'b01001		/*	09	trap if greater or eqaul immediate unsigned */
`define 	TLTI		5'b01010		/*	10	trap if less than immediate */
`define	TLTIU		5'b01011		/*	11	trap if less than immediate unsigned */
`define	TEQI		5'b01100		/*	12	trap if equal immediate */
`define 	TNEI		5'b01110		/*	14	trap if not equal immediate */
`define	BLTZAL	5'b10000		/*	16	branch on less than zero and link */
`define	BGEZAL	5'b10001		/*	17	branch on greater than or equal to zero and link */
`define	BLTZALL	5'b10010		/*	18	branch on less than zero likely and link */
`define	BGEZALL	5'b10011		/*	19	branch on greater than or equal to zero likely and link */

/* Coprocessor 0 (System Coprocessor) OP CODES (OPCODE == COP0) */
`define	MF			5'b00000		/*	00	Move From */
`define	MT			5'b00100		/*	01	Move To */
`define	C0			5'b10000		/*	16	 */
`define	RFE		5'b10000		/* 16 Restore from Exception */

/*****Registers****************************************************************/

`define	r_0		5'b00000		/*	00	zero register */
`define	rzero		5'b00000		/*	00	zero register */
`define	at			5'b00001		/*	01	*/
`define	v_0		5'b00010		/*	02	return register 0 */
`define	v_1		5'b00011		/*	03	return register 1 */
`define	a_0		5'b00100		/*	04	input register 0 */
`define	a_1		5'b00101		/*	05	input register 1 */
`define	a_2		5'b00110		/*	06	input register 2 */
`define	a_3		5'b00111		/*	07	input register 3 */
`define	t_0		5'b01000		/*	08	temporary register 0 */
`define	t_1		5'b01001		/*	09	temporary register 1 */
`define	t_2		5'b01010		/*	10	temporary register 2 */
`define	t_3		5'b01011		/*	11	temporary register 3 */
`define	t_4		5'b01100		/*	12	temporary register 4 */
`define	t_5		5'b01101		/*	13	temporary register 5	*/
`define	t_6		5'b01110		/*	14	temporary register 6 */
`define	t_7		5'b01111		/*	15	temporary register 7 */
`define	s_0		5'b10000		/*	16	data register 0 */
`define	s_1		5'b10001		/*	17	data register 1 */
`define	s_2		5'b10010		/*	18	data register 2 */
`define	s_3		5'b10011		/*	19	data register 3 */
`define	s_4		5'b10100		/*	20	data register 4 */
`define	s_5		5'b10101		/*	21 data register 5 */
`define	s_6		5'b10110		/*	22	data register 6 */
`define	s_7		5'b10111		/*	23	data register 7 */
`define	t_8		5'b11000		/* 24	temporary register 8 */
`define	t_9		5'b11001		/* 25 temporary register 9 */
`define	k_0		5'b11010		/* 26	*/
`define	k_1		5'b11011		/* 27	*/
`define	gp			5'b11100		/* 28 global pointer */
`define	sp			5'b11101		/* 29 stack pointer */
`define	s_8		5'b11110		/* 30 data register 8 */
`define	sra		5'b11111		/* 31 return address pointer */

/*****Exceptions****************************************************************/

/* Exception Types */
`define	Int		4'b0000		/*	00	Hardware/Software Interrupt */
`define	MOD		4'b0001		/*	01	TLB modification exception */
`define	TLBL		4'b0010		/*	02	TLB miss exception (Load or Instruction Fetch) */
`define	TLBS		4'b0011		/*	03	TLBS miss exception (Store) */
`define	AdEL		4'b0100		/*	04	Address error exception (Load or Instruction Fetch) */
`define	AdES		4'b0101		/*	05	Address error exception (Store) */
`define	IBE		4'b0110		/*	06	Bus error exception (for an instruction fetch) */
`define	DBE		4'b0111		/*	07	Bus error exception (for a data load or store) */
`define	SYS		4'b1000		/*	08	Syscall exception */
`define	Bp			4'b1001		/*	09	Breakpoint exception */
`define	RI			4'b1010		/*	10	Reserved Instruction exception */
`define	CpU		4'b1011		/*	11	Coprocessor Unusable exception */
`define	Ovf		4'b1100		/*	12	Arithmetic overflow exception */
`define	Tr			4'b1101		/*	13	Trap exception */

/* Exception Codes */
`define	Int0c		7'b0000000	/*	00		Software Interrupt 0 */
`define	Int1c		7'b0000001	/*	01		Software Interrupt 1 */
`define	Int2c		7'b0000010	/* 02		Hardware Interrupt 0 */
`define	Int3c		7'b0000011	/* 03		Hardware Interrupt 1 */
`define	Int4c		7'b0000100	/* 04 	Hardware Interrupt 2 */
`define	Int5c		7'b0000101	/* 05 	Hardware Interrupt 3 */
`define	Int6c		7'b0000110	/*	06		Hardware Interrupt 4 */
`define	Int7c		7'b0000111	/* 07 	Hardware Interrupt 5 */
`define	MODc		7'b0001000	/* 08		TLB modification exception */
`define	TLBLc		7'b0010000	/*	16 	TLB miss exception (Load or Instruction Fetch) */
`define	UTLBLc	7'b0010100	/* 20 	User Mode TLB miss exception (Load or Instruction Fetch) */
`define	TLBSc		7'b0011000	/*	24 	TLB miss exception (Store) */
`define	UTLBSc	7'b0011100	/* 28 	User Mode TLB miss exception (Store) */
`define	AdELc		7'b0100000	/*	32		Address error exception (Load or Instruction Fetch) */
`define	AdESc		7'b0101000	/*	40		Address error exception (Store) */
`define	IBEc		7'b0110000	/*	48		Bus error exception (for an instruction fetch) */
`define	DBEc		7'b0111000	/*	56		Bus error exception (for a data load or store) */
`define	SYSc		7'b1000000	/*	64		Syscall exception */
`define	Bpc		7'b1001000	/*	72		Breakpoint exception */
`define	RIc		7'b1010000	/*	80		Reserved Instruction exception */
`define	CpU0c		7'b1011000	/*	88		Coprocessor0 Unusable exception */
`define	CpU1c		7'b1011001	/* 89		Coprocessor1 Unusable exception */	
`define	CpU2c		7'b1011010	/* 90		Coprocessor2 Unusable exception */
`define	CpU3c		7'b1011011	/* 91		Coprocessor3 Unusable exception */
`define	Ovfc		7'b1100000	/*	96		Arithmetic overflow exception */
`define	Trc		7'b1101000	/*	104	Trap exception */
`define	RSTc		7'b1111011	/*	123	Reset exception */

/*****Misc****************************************************************/
`define	BLANK4	4'h00
`define	BLANK5	5'h00
`define	BLANK6	6'h00
`define	BLANK32	32'h00000000
`define	BLANK33	33'h000000000
`define	BLANK34	34'h000000000
`define	BLANK35	35'h000000000


