/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*					Bharat Sukhwani													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	extension0_timer_controller_ext							*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	EXTENSION0 is an instantiation of an eMIPS Extension.  This			*/
/*	serves as a wrapper module with the Extension interface defined.	*/
/*	To insert an Extension into the design for a build it is				*/
/*	instantiated inside of this wrapper an connected to the				*/
/*	appropriate interfaces.  The EXTENSION0 includes interfaces to		*/
/*	the pipeline stages, register file and memory.							*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	Peripheral Extension, Timer							*/
/*																							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module extension0/*_timer_controller_ext*/(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input				BAT_EN_IN,		/* */
	input [1:0]		BYTES,			/* */
	input 			CLK,				/* System Clock 50 - 100 MHZ */
	input 			EN,				/* Enable */
	input 			ENEXT,			/* Execution Enable */
	input 			EXCEXT,			/* Exception Flush */
	input				EXTCLK_EN,	/* */
	input 			EXTNOP_EX,		/* Extension Bubble in Execute Phase */
	input 			EXTNOP_MA,		/* Extension Bubble in Memory Access Phase */
	input 			GR,				/* Grant Pipeline Resources */
	input [31:0]	INSTR,			/* Current Instruction */
	input				LDEXT,	/* */
	input [31:0]	MADDR_IN,		/* Peripheral Memory Addresss */
											/* Multiplexed: */
											/* 	Peripheral Memory Addresss */
											/* 	Memory Address Monitor */
	input [31:0]	MDATA_IN,		/* Memory Data In */
											/* Multiplexed: */
											/* 	Memory Data In */
											/* 	Peripheral Memory Data In */
											/* 	Memory Data Monitor */
	input 			MDATA_VLD_IN,	/* Memory Data Valid */
	input 			OE_IN,			/* Peripheral Output Enable */
											/* Multiplexed: */
											/* 	Peripheral Output Enable */
											/* 	Memory Output Enable Monitor */
	input [31:0]	PC,				/* Current PC External */
	input 			PCLK,				/* Pipeline Clock */
	input [31:0]	RDREG1DATA,		/* Register Read Port 1 Register Data */
	input [31:0]	RDREG2DATA,		/* Register Read Port 2 Register Data */
	input [31:0]	RDREG3DATA,		/* Register Read Port 3 Register Data */
	input [31:0]	RDREG4DATA,		/* Register Read Port 4 Register Data */
	input 			REGEMPTY,		/* Register Write Buffer Empty */
	input 			REGFULL,			/* Register Write Buffer Full */
	input 			REGRDY,			/* Register Write Buffer Ready */
	input 			REGWRITE1_RG,	/* Register Write Port 1 Write Enable Monitor */
	input 			REGWRITE2_RG,	/* Register Write Port 2 Write Enable Monitor */
	input 			RESET,			/* System Reset */
	input				SRT,	/* */
	input 			WE_IN,			/* Peripheral Write Enable */
											/* Multiplexed: */
											/* 	Peripheral Write Enable */
											/* 	Memory Write Enable Monitor */
	input [31:0]	WRDATA1_RG,		/* Register Write Port 1 Data Monitor */
	input [31:0]	WRDATA2_RG,		/* Register Write Port 2 Data Monitor */
	input [4:0]		WRREG1_RG,		/* Register Write Port 1 Register Number Monitor */
	input [4:0]		WRREG2_RG,		/* Register Write Port 2 Register Number Monitor */
	input 			RX,
	/* OUTPUT PORTS */
	output			ACK,				/* Enable Acknowledged */
	output			BLS_OUT,			/* Byte Load/Store */
	output			DNE_OUT,			/* */
	output			EXC,				/* Exception */
	output			EXC_OUT,			/* Exception M */
	output [31:0]	EXTADD,			/* Extension Address */
											/* Multiplexed: */
											/* 	Next PC */
											/* 	Exception Address */
											/* 	PC Execute Phase */
											/* 	PC Memory Access Phase */
	output 			HLS_OUT,			/* Halfword Load/Store */
	output			INT_OUT,			/* Interrupt */
	output [31:0]	MADDR_OUT,		/* Memory Address */
	output [31:0]	MDATA_OUT,		/* Memory Data Out */
											/* Multiplexed: */
											/* 	Memory Data Out */
											/* 	Peripheral Memory Data Out */
	output			MLOCK_OUT,		/* Memory Automic Lock */
	output			MOE_OUT,			/* Memory Output Enable */
	output			MWE_OUT,			/* Memory Write Enable */
	output			MY_ADDR_OUT,	/* */
	output			PCNEXT,			/* Conditional PC Update */
	output			PI,				/* Passive/Parrallel Instruction */
	output			PRESENT_OUT,	/* */
	output			PRIVILEGE_OUT,	/* */
	output [4:0]	RDREG1,			/* Register Read Port 1 Register Number */
											/* Multiplexed: */
											/* 	Register Read Port 1 Register Number */
											/* 	Register Write Port 1 Register Number */
											/* 	Write Register Execute Phase */
											/* 	Write Register Memory Access Phase */
	output [4:0]	RDREG2,			/* Register Read Port 2 Register Number */
											/* Multiplexed: */
											/* 	Register Read Port 2 Register Number */
											/* 	Register Write Port 2 Register Number */
											/* 	<0> Register Write Enable Execute Phase */
											/*		<0> Register Write Enable Memory Access Phase */
											/* 	<1> Memory to Register Execute Phase */
											/* 	<1> Memory to Register Memory Acess Phase */
											/* 	<3> Load/Store Conditional Execute Phase */
											/* 	<4> Extended Memory Data Execute Phase */
	output [4:0]	RDREG3,			/* Register Read Port 3 Register Number */
											/* Multiplexed: */
											/* 	Register Read Port 3 Register Number */
											/* 	Exception Code [4:0] */
	output [4:0]	RDREG4,			/* Register Read Port 4 Register Number */
											/* Multiplexed: */
											/* 	Register Read Port 4 Register Number */
											/* 	<0> Memory Write Execute Phase */
											/* 	<1> Memory Read Execute Phase */
											/* 	<1:0> Data Address [1:0] Memory Access Phase */
											/*		<2> Right/Left Unaligned Load/Store Execute Phase */
											/*		<2> Right/Left Unaligned Load/Store Memory Access Phase */
											/* 	<3> Byte Load/Store Execute Phase */
											/* 	<3> Byte/Halfword Load/Store Memory Acess Phase */
											/* 	<4> Halfword Load/Store Execute */
	output			REGWRITE1,		/* Register Write Port 1 Write Enable */
	output			REGWRITE2,		/* Register Write Port 2 Write Enable */
	output			REMA,				/* Re-enter at Memory Access */
	output			REWB,				/* Re-enter at Writeback */
	output			RI,				/* Reserved/Recognized Instruction */
	output			RNL_OUT,			/* Memory Right/Left Unaligned Load/Store */
	output			WANT_INTR_OUT,	/* */
	output [31:0]	WRDATA1,			/* Register Write Port 1 Data */
											/* Multiplexed: */
											/* 	Register Write Port 1 Data */
											/* 	ALU Result Execute Phase */
											/* 	ALU Result Memory Access Phase */
	output [31:0]	WRDATA2,			/* Register Write Port 2 Data */
											/* Multiplexed: */
											/* 	Register Write Port 2 Data */
											/* 	Register 2 Data Execute Phase */
											/* 	Memory Data Out Memory Access Phase */
	output			TX,
	output			fspecial			/* Register type selector on RegPort interface 1. (0=GPR, 1=other regs) */
	);

	assign ACK = 1'b0;
	assign BLS_OUT = 1'b0;
	assign EXC = 1'b0;
	assign EXC_OUT = 1'b0;
	assign EXTADD = 32'h0;
	assign HLS_OUT = 1'b0;
	assign MADDR_OUT = 32'h0;
	assign MLOCK_OUT = 1'b0;
	assign MOE_OUT = 1'b0;
	assign MWE_OUT = 1'b0;
	assign PCNEXT = 1'b0;
	assign PI = 1'b0;
	assign RDREG1 = 5'b0;
	assign RDREG2 = 5'b0;
	assign RDREG3 = 5'b0;
	assign RDREG4 = 5'b0;
	assign REGWRITE1 = 1'b0;
	assign REGWRITE2 = 1'b0;
	assign REMA = 1'b0;
	assign REWB = 1'b0;
	assign RI = 1'b1;
	assign RNL_OUT = 1'b0;
	assign WRDATA1 = 32'h0;
	assign WRDATA2 = 32'h0;

	timer_controller_ext tce(
		.ADDR_IN(MADDR_IN),
		.BYTES(BYTES),
		.CADDR(32'b0),
		.CLK(CLK),
		.DATA_IN(MDATA_IN),
		.OE(OE_IN),
		.RESET(RESET),
		.SRT(SRT),
		.TMRCLK(CLK),
		.WE(WE_IN),
		.BAT_EN(BAT_EN_IN),
		.EXTCLK_EN(EXTCLK_EN),
		//.BASETAG(),
		.DATA_OUT(MDATA_OUT),
		.DNE(DNE_OUT),
		//.STATUS(),
		//.TDIRQ(),
		//.TFIRQ(),
		.PRESENT(PRESENT_OUT),
		.WANT_INTR(WANT_INTR_OUT),
		.PRIVILEGE(PRIVILEGE_OUT),
		.MY_ADDR(MY_ADDR_OUT),
		.IRQ(INT_OUT),
		.LDEXT(LDEXT)
		//.CLK_EXT()
		);

endmodule
