/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	key																*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	Peripheral Extension, USART							*/
/*																							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module key(
	input CLK,
	input CLK_EN,
	input EXT_LD,
	input PRESENT,
	input RESET,
	output PRESENT_K
	);
	
	reg [3:0]	selcount;
	reg [1:0]	state;
	
	parameter KEYPHRASE	=	14'b00111000011111;
	
	initial
	begin
		selcount = 4'hf;
		state = 2'b0;
	end
	
	keymux km(
		.key(KEYPHRASE),
		.sel(selcount),
		.serkey(PRESENT_K)
		);
	
	always@(posedge CLK)
	begin
		if (~RESET)
		begin
			selcount <= 4'hf;
			state <= 2'b0;
		end
		else
		begin
			case(state)
				2'b00		:	begin
									selcount <= 4'hf;
									if (CLK_EN & PRESENT)
									begin
										state <= 2'b01;
									end
								end
				2'b01		:	begin
									if (selcount >= 13) selcount <= 0;
									else selcount <= selcount + 1;
									if (EXT_LD)
									begin
										state <= 2'b10;
									end
									if (~CLK_EN | ~PRESENT)
									begin
										state <= 2'b00;
									end
								end
				2'b10		:	begin
									selcount <= 4'he;
									if (~CLK_EN | ~PRESENT)
									begin
										state <= 2'b00;
									end
								end
				default	:	begin
								end
			endcase
		end
	end
	
endmodule

module keymux(
	input [13:0] key,
	input [3:0] sel,
	output serkey
	);
	
	assign serkey = 	(sel == 4'b0000)?	key[13]:
							(sel == 4'b0001)? key[12]:
							(sel == 4'b0010)? key[11]:
							(sel == 4'b0011)?	key[10]:
							(sel == 4'b0100)?	key[9]:
							(sel == 4'b0101)?	key[8]:
							(sel == 4'b0110)?	key[7]:
							(sel == 4'b0111)?	key[6]:
							(sel == 4'b1000)? key[5]:
							(sel == 4'b1001)? key[4]:
							(sel == 4'b1010)? key[3]:
							(sel == 4'b1011)?	key[2]:
							(sel == 4'b1100)?	key[1]:
							(sel == 4'b1101)?	key[0]:
							(sel == 4'b1110)?	1'b1:
													1'b0;
endmodule
