/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	receiver_dp														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	Uart receiver datapath															*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	Peripheral Extension, USART							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module receiver_dp(clk, rst, RxD, count, load_sr, set_count, 
							end_count, data);

// Input Ports
input clk;
input rst;
input RxD;

input count;
input load_sr;
input set_count;


// Output Ports
output end_count;
output [7:0] data;

// Regs
reg [7:0] shift_reg;
reg [2:0] count_reg;

initial
begin
	shift_reg = 8'b0;
	count_reg = 3'b0;
end
 
//
// DATAPATH
//

// ShiftReg
always @(posedge clk)
if (rst)
	shift_reg <= 0;
else  if (load_sr)
			shift_reg <= {RxD,shift_reg[7:1]};

// DownCounter
always @(posedge clk)
if (rst)
		count_reg <= 3'b111;
else if (set_count)
				count_reg <= 3'b111;
		else  if (count)
					count_reg <= count_reg - 1;
						
						
assign end_count = (count_reg == 0);

assign data = shift_reg;

endmodule
