/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Giovanni Busonera													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	transmitter_ext												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	Uart Transmitter module															*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	Peripheral Extension, USART							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module transmitter_ext(clk, rst, TxD_Start, baud_pulse, TxD_Data,
							baud_gen_init, baud_gen_en, TxD, busy);
							
// Input Ports
input clk;
input rst;
input TxD_Start;
input baud_pulse;
input [7:0] TxD_Data;

// Output Ports
output baud_gen_init;
output baud_gen_en;
output TxD;
output busy;

// Wires
wire load_data;
wire shift;
wire count;
wire set_count;
wire end_count;
wire [1:0] out_sel;

// Modules Instances

transmitter_dp TRANSMITTER_DP (
    .clk(clk), 
    .load_data(load_data), 
    .shift(shift), 
    .count(count), 
    .set_count(set_count), 
    .out_sel(out_sel), 
    .TxD_Data(TxD_Data), 
    .end_count(end_count), 
    .TxD(TxD)
    );


transmitter_fsm TRANSMITTER_FSM (
    .clk(clk), 
    .rst(rst), 
    .TxD_Start(TxD_Start), 
    .end_count(end_count), 
    .baud_pulse(baud_pulse), 
    .load_data(load_data), 
    .count(count), 
    .shift(shift), 
    .set_count(set_count), 
    .out_sel(out_sel), 
    .baud_gen_init(baud_gen_init), 
    .baud_gen_en(baud_gen_en), 
    .busy(busy)
    );							


endmodule
