//Richard Neil Pittman
//Microsoft Corp 2006

`include "decode.v"

`define OPc		instr[31:26]
`define RDc		instr[15:11]
`define RSc		instr[25:21]
`define RTc		instr[20:16]
`define IMMc	instr[15:0]
`define TARc	instr[25:0]
`define SAc		instr[10:6]
`define FUNCc	instr[5:0]

task decode_instr;
	input db;
	input EN;
	input [31:0] instredf;
	input [31:0] pc;

	reg [31:0] instr;

	begin

		instr[31:24] =	(EN == 1'b1)?instredf[7:0]:instredf[31:24];
		instr[23:16] =	(EN == 1'b1)?instredf[15:8]:instredf[23:16];
		instr[15:8] =	(EN == 1'b1)?instredf[23:16]:instredf[15:8];
		instr[7:0] =	(EN == 1'b1)?instredf[31:24]:instredf[7:0];
	
		//$display("%x",instredf);
		//$display("INSTR %x",instr);

		//$display("%b %b %b %b %b %b", `OPc, `RSc, `RTc, `RDc, `SAc, `FUNCc);
		if (pc > 32'b0)
		begin
			casex(instr)
				32'b0						:	begin
												$display("%x:\tNOP", pc);
											end
				{`SPEC,15'bx,5'bx,`ADD}			:	begin
												$display("%x:\tADD $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`ADDI,26'bx}				:	begin
												$display("%x:\tADDI $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
												//if (`RTc == 8) $stop;
											end
				{`ADDIU,26'bx}				:	begin
												$display("%x:\tADDIU $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
												//$stop;
											end
				{`SPEC,15'bx,5'bx,`ADDU}		:	begin
												$display("%x:\tADDU $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`SPEC,15'bx,5'bx,`AND}			:	begin
												$display("%x:\tAND $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`ANDI,26'bx}				:	begin
												$display("%x:\tANDI $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
												end
				{`BEQ,26'bx}				:	begin
												$display("%x:\tBEQ $%d, $%d, %x", pc, `RSc, `RTc, `IMMc);
												//$stop;
											end
				{`BEQL,26'bx}				:	begin
												$display("%x:\tBEQL $%d, $%d, %x", pc, `RSc, `RTc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BGEZ,16'bx}		:	begin
												$display("%x:\tBGEZ $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BGEZAL,16'bx}		:	begin
												$display("%x:\tBGEZAL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BGEZALL,16'bx}		:	begin
												$display("%x:\tBGEZALL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BGEZL,16'bx}		:	begin
												$display("%x:\tBGEZL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BGTZ,5'bx,5'bx,16'bx}			:	begin
												$display("%x:\tBGTZ $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BGTZL,5'bx,5'bx,16'bx}		:	begin
												$display("%x:\tBGTZL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BLEZ,5'bx,5'bx,16'bx}			:	begin
												$display("%x:\tBLEZ $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BLEZL,5'bx,5'bx,16'bx}		:	begin
												$display("%x:\tBLEZL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BLTZ,16'bx}		:	begin
												$display("%x:\tBLTZ $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BLTZAL,16'bx}		:	begin
												$display("%x:\tBLTZAL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BLTZALL,16'bx}		:	begin
												$display("%x:\tBLTZALL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BCOND,5'bx,`BLTZL,16'bx}		:	begin
												$display("%x:\tBLTZL $%d, %x", pc, `RSc, `IMMc);
												//$stop;
											end
				{`BNE,26'bx}				:	begin
												$display("%x:\tBNE $%d, $%d, %x", pc, `RSc, `RTc, `IMMc);
												//$stop;
											end
				{`BNEL,26'bx}				:	begin
												$display("%x:\tBNEL $%d, $%d, %x", pc, `RSc, `RTc, `IMMc);
												//$stop;
											end
				{`SPEC,20'bx,`BREAK}			:	begin
												$display("%x:\tBREAK", pc);
											end
				{`SPEC,10'bx,10'bx,`DIV}		:	begin
												$display("%x:\tDIV $%d, $%d", pc, `RSc, `RTc);
												if (db) $stop;
											end
				{`SPEC,10'bx,10'bx,`DIVU}		:	begin
												$display("%x:\tDIVU $%d, $%d", pc, `RSc, `RTc);
												if (db) $stop;
											end
				{`J,26'bx}					:	begin
												$display("%x:\tJ %x", pc, `TARc);
												//$stop;
											end
				{`JAL,26'bx}				:	begin
												$display("%x:\tJAL %x", pc, `TARc);
												//$stop;
											end
				{`SPEC,5'bx,5'bx,5'bx,5'bx,`JALR}	:	begin
												$display("%x:\tJALR $%d, $%d", pc, `RDc, `RSc);
												//$stop;
											end
				{`SPEC,5'bx,15'bx,`JR}			:	begin
												$display("%x:\tJR $%d", pc, `RSc);
												//$stop;
											end
				{`LB,26'bx}					:	begin
												$display("%x:\tLB $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LBU,26'bx}				:	begin
												$display("%x:\tLBU $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LH,26'bx}					:	begin
												$display("%x:\tLH $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LHU,26'bx}				:	begin
												$display("%x:\tLHU $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LUI,5'bx,21'bx}				:	begin
												$display("%x:\tLUI $%d, %x", pc, `RTc, `IMMc);
											end
				{`LW,26'bx}					:	begin
												$display("%x:\tLW $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LL,26'bx}					:	begin
												$display("%x:\tLL $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
												//$stop;
											end
				{`LWL,26'bx}				:	begin
												$display("%x:\tLWL $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LWR,26'bx}				:	begin
												$display("%x:\tLWR $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`LWU,26'bx}				:	begin
												$display("%x:\tLWU $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`SPEC,10'bx,5'bx,5'bx,`MFHI}		:	begin
												$display("%x:\tMFHI $%d", pc, `RDc);
											end
				{`SPEC,10'bx,5'bx,5'bx,`MFLO}		:	begin
												$display("%x:\tMFLO $%d", pc, `RDc);
											end
				{`SPEC,15'bx,5'bx,`MOVN}		:	begin
												$display("%x:\tMOVN $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`SPEC,15'bx,5'bx,`MOVZ}		:	begin
												$display("%x:\tMOVZ $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`SPEC,5'bx,15'bx,`MTHI}		:	begin
												$display("%x:\tMTHI $%d", pc, `RSc);
											end
				{`SPEC,5'bx,15'bx,`MTLO}		:	begin
												$display("%x:\tMTLO $%d", pc, `RSc);
											end
				{`SPEC,10'bx,10'bx,`MULT}		:	begin
												$display("%x:\tMULT $%d, $%d", pc, `RSc, `RTc);
											end
				{`SPEC,10'bx,10'bx,`MULTU}		:	begin
												$display("%x:\tMULTU $%d, $%d", pc, `RSc, `RTc);
											end
				{`SPEC,15'bx,5'bx,`NOR}			:	begin
												$display("%x:\tNOR $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`SPEC,15'bx,5'bx,`OR}			:	begin
												$display("%x:\tOR $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`ORI,26'bx}				:	begin
												$display("%x:\tORI $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
											end
				{`SB,26'bx}					:	begin
												$display("%x:\tSB $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
												//$stop;
											end
				{`SH,26'bx}					:	begin
												$display("%x:\tSH $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
												//$stop;
											end
				{`SPEC,5'bx,15'bx,`SLL}			:	begin
												$display("%x:\tSLL $%d, $%d, %x", pc, `RDc, `RTc, `SAc);
											end
				{`SPEC,15'bx,5'bx,`SLLV}		:	begin
												$display("%x:\tSLLV $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`SPEC,15'bx,5'bx,`SLT}			:	begin
												$display("%x:\tSLT $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
											end
				{`SLTI,26'bx}				:	begin
												$display("%x:\tSLTI $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
											end
				{`SLTIU,26'bx}				:	begin
												$display("%x:\tSLTIU $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
											end
				{`SPEC,15'bx,5'bx,`SLTU}		:	begin
												$display("%x:\tSLTU $%d, $%d, $%d", pc, `RDc, `RSc, `RTc);
												//$stop;
											end
				{`SPEC,5'bx,15'bx,`SRA}			:	begin
												$display("%x:\tSRA $%d, $%d, %x", pc, `RDc, `RTc, `SAc);
											end
				{`SPEC,15'bx,5'bx,`SRAV}		:	begin
												$display("%x:\tSRAV $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`SPEC,5'bx,15'bx,`SRL}			:	begin
												$display("%x:\tSRL $%d, $%d, %x", pc, `RDc, `RTc, `SAc);
											end
				{`SPEC,15'bx,5'bx,`SRLV}		:	begin
												$display("%x:\tSRLV $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`SPEC,15'bx,5'bx,`SUB}			:	begin
												$display("%x:\tSUB $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`SPEC,15'bx,5'bx,`SUBU}		:	begin
												$display("%x:\tSUBU $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`SW,26'bx}					:	begin
												$display("%x:\tSW $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
												//$stop;
											end
				{`SC,26'bx}					:	begin
												$display("%x:\tSC $%d, %x($%d)", pc, `RTc, `IMMc, `RSc);
												//$stop;
											end
				{`SWL,26'bx}				:	begin
												$display("%x:\tSWL $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`SWR,26'bx}				:	begin
												$display("%x:\tSWR $%d, $%d($%d)", pc, `RTc, `IMMc, `RSc);
											end
				{`SPEC,20'bx,`SYSCALL}			:	begin
												$display("%x:\tSYSCALL", pc);
											end
				{`SPEC,20'bx,`TEQ}			:	begin
												$display("%x:\tTEQ $%d, $%d", pc, `RSc, `RTc);
											end
				{`BCOND,5'bx,`TEQI,16'bx}		:	begin
												$display("%x:\tTEQI $%d, %x", pc, `RSc, `IMMc);
											end
				{`SPEC,20'bx,`TGE}			:	begin
												$display("%x:\tTGE $%d, $%d", pc, `RSc, `RTc);
											end
				{`BCOND,5'bx,`TGEI,16'bx}		:	begin
												$display("%x:\tTGEI $%d, %x", pc, `RSc, `IMMc);
											end
				{`BCOND,5'bx,`TGEIU,16'bx}		:	begin
												$display("%x:\tTGEIU $%d, %x", pc, `RSc, `IMMc);
											end
				{`SPEC,20'bx,`TGEU}			:	begin
												$display("%x:\tTGEU $%d, $%d", pc, `RSc, `RTc);
											end
				{`SPEC,20'bx,`TLT}			:	begin
												$display("%x:\tTLT $%d, $%d", pc, `RSc, `RTc);
											end
				{`BCOND,5'bx,`TLTI,16'bx}		:	begin
												$display("%x:\tTLTI $%d, %x", pc, `RSc, `IMMc);
											end
				{`BCOND,5'bx,`TLTIU,16'bx}		:	begin
												$display("%x:\tTLTIU $%d, %x", pc, `RSc, `IMMc);
											end
				{`SPEC,20'bx,`TLTU}			:	begin
												$display("%x:\tTLTU $%d, $%d", pc, `RSc, `RTc);
											end
				{`SPEC,20'bx,`TNE}			:	begin
												$display("%x:\tTNE $%d, $%d", pc, `RSc, `RTc);
											end
				{`BCOND,5'bx,`TNEI,16'bx}		:	begin
												$display("%x:\tTNEI $%d, %x", pc, `RSc, `IMMc);
											end
				{`SPEC,15'bx,5'bx,`XOR}			:	begin
												$display("%x:\tXOR $%d, $%d, $%d", pc, `RDc, `RTc, `RSc);
											end
				{`XORI,26'bx}				:	begin
												$display("%x:\tXORI $%d, $%d, %x", pc, `RTc, `RSc, `IMMc);
											end
				{`COP0,`MF,5'bx,5'bx,11'bx}		:	begin
												$display("%x:\tMFC0 $%d, $%d", pc, `RTc, `RDc);
											end
				{`COP0,`MT,5'bx,5'bx,11'bx}		:	begin
												$display("%x:\tMTC0 $%d, $%d", pc, `RTc, `RDc);
											end
				{`COP0,`C0,16'bx,`RFE}			:	begin
												$display("%x:\tRFE", pc);
											end
				{6'b111111,5'b00000,5'bx,5'bx,11'bx}	:	begin
												$display("%x:\tEXMR $%d, $%d", pc, `RTc, `RDc);
												//$stop;
											end
				{6'b011110,5'bx,5'bx,16'bx}		:	begin
												$display("%x:\tSLL128 $%d, $%d", pc, `RSc, `RTc, `IMMc);
												//$stop;
											end
				default					:	begin
												$display("%x:\t%x", pc, instr);
												//$display("ERROR:  INSTRUCTION NOT RECOGNIZED");
												//$stop;
											end
			endcase
		end
		else
		begin
			$display("xxxxxxxx:\BUBBLE");
		end
	end
endtask