//Richard Neil Pittman
//Microsoft Corp 2006

module testMIPS();

	reg clk;
	reg reset;
	reg [5:0] counter;

	wire RX2, TX2;

	initial 
	begin
		clk = 1;
		reset = 0;
		counter = 6'b0;
	end

	always
		#5000 clk = ~clk;

	/*always@(posedge clk)
	begin
		$stop;
	end*/

	always@(negedge clk)
	begin
		if (counter == 6'b100)
		begin
			reset = 1;
		end
	end

	always@(negedge clk)
	begin
		//$display ("Cycle %d",counter);
		counter = counter + 1;
	end

	MIPSPL_FPGA3 emips(
		//.BRDY(),			/* System Ace Buffer Ready */
		.CLK(clk),			/* Board System Clock 100 MHZ */
		.CLK_IN_PER(clk),	/* System Ace Clock 33 MHZ */
		//.IRQ_SYSACE(),	/* System Ace Interrupt Request */
		.RESET(reset),		/* Board Hardware Reset */
		//.RX(),			/* System Serial Recieve */
		//.SRAMCLK_FB(),	/* SRAM Clock Feedback 50 - 100 MHZ */
		//.BYTE(),			/*  */
		//.BYTESEL(),		/*  */
		//.CE_FLASH(),	/* Flash Chip Enable */
		//.MADDR_OUT(),	/* Memory Address Bus (SRAM & Flash) */
		//.MODE(),			/* SRAM Mode */
		//.NADVLD(),		/* SRAM ADV/LD */
		//.NBW(),			/* SRAM Byte Write Enable */
		//.NCE_SRAM(),	/* SRAM Chip Enable */
		//.NCE_SYSACE(),	/* System Ace Chip Enable */
		//.NOE_MEM(),		/* Memory Output Enable (SRAM & Flash) */
		//.NOE_PER(),		/* Peripheral Output Enable (SYSACE) */
		//.NRP(),			/*  */
		//.NWE_MEM(),		/* Memory Write Enable (SRAM & Flash) */
		//.NWE_PER(),		/* Peripheral Write Enable (SYSACE) */
		//.PADDR_OUT(),	/* Peripheral Address Bus (SYSACE) */
		//.SCLK(),			/*  */
		//.SRAMCLK(),		/* SRAM Clock 50 - 100 MHZ */
		//.TX(),			/* System Serial Transmit */
		//.ZZ(),			/* SRAM Sleep */
		//.CLK_EXT(),		/*  */
		//.DATA_PAR(),	/* SRAM Parity Data Bus */
		//.GPIO(),			/* General Purpose Input/Output */
		//.MDATA(),		/* Memory Data Bus (SRAM & Flash) */
		//.PDATA(),			/* Peripheral Data Bus (SYSACE) */
		.RX2(RX2),
		.TX2(TX2)
	);

	/*serplexd_serial ss(
		.RX(TX2),
		.CLK(clk),
		.TX(RX2)
		);*/



endmodule