/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*					Bharat Sukhwani													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	TISA_black_box													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	TISA encapsulates all the modules in the eMIPS microprocessor 		*/
/*	system that makes up the Trusted ISA.  These modules include the	*/
/*	pipeline stages and supporting logic as well as the memory			*/
/*	subsystem including peripheral drivers and busses.						*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	eBug Extension, Extension Peripherals, Bug		*/
/*							Fixes, see Manual											*/
/*																							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module TISA/*_black_box*/(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input 			ACK_EXT0e,				/* Extension 0 Enable Acknowledged External */
	input 			BLS_EXT0_IN,			/* Extension 0 Byte Load/Store External */
	input 			BRAMCLK,					/* Blockram Clock 50 - 100 MHZ */
	input 			BRDY,						/* System Ace Buffer Ready */
	input 			CLK_IN_PER,				/* System Ace Clock 33 MHZ Buffered */
	input 			DCMLOCK,					/* Digital Clock Manager Lock */
	input 			EXC_EXT0_IN,			/* Extension 0 Exception M External */
	input 			EXC_EXT0e,				/* Extension 0 Exception External */
	input [31:0]	EXTADD_EXT0e,			/* Extension 0 Extension Address External */
													/* Multiplexed: */
													/*	Extension 0 Next PC */
													/*	Extension 0 Exception Address */
													/*	Extension 0 PC Execute Phase */
													/*	Extension 0 PC Memory Access Phase */
	input 			FLASHCLK,				/* Flash Memory Interface Clock 50 - 100 MHZ */
	input [31:0]	GPIO_OUT,				/* GPIO data out of tristate buffer in to FPGA */
	input 			HLS_EXT0_IN,			/* Extension 0 Halfword Load/Store External */
	input 			INT_EXT0_IN,			/* Extension 0 Interrupt External */
	input 			IRQ_SYSACE,				/* System Ace Interrupt Request */
	input [31:0]	MADDR_EXT0_IN,			/* Extension 0 Memory Address External */
	input [31:0]	MDATA_EXT0_IN,			/* Extension 0 Memory Data Out External */
													/* Multiplexed: */
													/* 	Extension 0 Memory Data Out */
													/* 	Extension 0 Peripheral Memory Data Out */
	input [31:0]	MDATA_OUT,				/* Memory data bus out of tristate buffer in to FPGA */
	input [3:0]		MDATAP_OUT,				/* Memory data parity bus out of tristate buffer in to FPGA */
	input				MEMCLK,					/* Memory Interface to Data Path Clock 50 - 100 MHZ */
	input				MEMCLK2,					/* Memory Interface to Peripherals Clock 50 - 100 MHZ */
	input				MLOCK_EXT0_IN,			/* Extension 0 Memory Automic Lock External */
	input				MOE_EXT0_IN,			/* Extension 0 Memory Output Enable External */
	input				MWE_EXT0_IN,			/* Extension 0 Memory Write Enable External */
	input				PCNEXT_EXT0e,			/* Extension 0 Conditional PC Update External */
	input [15:0]	PDATA_OUT,				/* Peripheral data bus out of tristate buffer in to FPGA */
	input				PER0_DNE_IN,			/* */
	input				PER0_MY_ADDR_IN,		/* */
	input				PER0_PRESENT_IN,		/* */
	input				PER0_PRIVILEGE_IN,	/* */
	input				PER0_WANTS_INTR_IN,	/* */
	input				PI_EXT0e,				/* Extension 0 Passive/Parrallel Instruction External */
	input [4:0]		RDREG1_EXT0e,			/* Extension 0 Register Read Port 1 Register Number External */
													/* Multiplexed: */
													/* 	Extension 0 Register Read Port 1 Register Number */
													/* 	Extension 0 Register Write Port 1 Register Number */
													/* 	Extension 0 Write Register Execute Phase */
													/* 	Extension 0 Write Register Memory Access Phase */
	input [4:0]		RDREG2_EXT0e,			/* Extension 0 Register Read Port 2 Register Number External */
													/* Multiplexed: */
													/* 	Extension 0 Register Read Port 2 Register Number */
													/* 	Extension 0 Register Write Port 2 Register Number */
													/* 	<0> Extension 0 Register Write Enable Execute Phase */
													/*		<0> Extension 0 Register Write Enable Memory Access Phase */
													/* 	<1> Extension 0 Memory to Register Execute Phase */
													/* 	<1> Extension 0 Memory to Register Memory Acess Phase */
													/* 	<3> Extension 0 Load/Store Conditional Execute Phase */
													/* 	<4> Extension 0 Extended Memory Data Execute Phase */
	input [4:0]		RDREG3_EXT0e,			/* Extension 0 Register Read Port 3 Register Number External */
													/* Multiplexed: */
													/* 	Extension 0 Register Read Port 3 Register Number */
													/* 	Extension 0 Exception Code [4:0] */
	input [4:0]		RDREG4_EXT0e,			/* Extension 0 Register Read Port 4 Register Number External */
													/* Multiplexed: */
													/* 	Extension 0 Register Read Port 4 Register Number */
													/* 	<0> Extension 0 Memory Write Execute Phase */
													/* 	<1> Extension 0 Memory Read Execute Phase */
													/* 	<1:0> Extension 0 Data Address [1:0] Memory Access Phase */
													/*		<2> Extension 0 Right/Left Unaligned Load/Store Execute Phase */
													/*		<2> Extension 0 Right/Left Unaligned Load/Store Memory Access Phase */
													/* 	<3> Extension 0 Byte Load/Store Execute Phase */
													/* 	<3> Extension 0 Byte/Halfword Load/Store Memory Acess Phase */
													/* 	<4> Extension 0 Halfword Load/Store Execute */
	input				REGWRITE1_EXT0e,		/* Extension 0 Register Write Port 1 Write Enable External */
	input				REGWRITE2_EXT0e,		/* Extension 0 Register Write Port 2 Write Enable External */
	input				REMA_EXT0e,				/* Extension 0 Re-enter at Memory Access External */
	input				RESET,					/* Hardware Reset */
	input				REWB_EXT0e,				/* Extension 0 Re-enter at Writeback External */
	input				RI_EXT0e,				/* Extension 0 Reserved/Recognized Instruction External */
	input				RNL_EXT0_IN,			/* Extension 0 Memory Right/Left Unaligned Load/Store External */
	input				RX,						/* System Serial Recieve */
	input				SRAMCLK,					/* SRAM Clock Internal 50 - 100 MHZ */
	input				SYSCLK,					/* System Clock 50 - 100 MHZ */
	input				TMRCLK,					/* Timer Clock 10 MHZ */
	input				USARTCLK,				/* USART Clock 100 MHZ */
	input [31:0]	WRDATA1_EXT0e,			/* Extension 0 Register Write Port 1 Data External */
													/* Multiplexed: */
													/* 	Extension 0 Register Write Port 1 Data */
													/* 	Extension 0 ALU Result Execute Phase */
													/* 	Extension 0 ALU Result Memory Access Phase */
	input [31:0]	WRDATA2_EXT0e,			/* Extension 0 Register Write Port 2 Data External */
													/* Multiplexed: */
													/* 	Extension 0 Register Write Port 2 Data */
													/* 	Extension 0 Register 2 Data Execute Phase */
													/* 	Extension 0 Memory Data Out Memory Access Phase */
	input				fspecial_EXT0e,		/* */
	/* OUTPUT PORTS */
	output [31:0]	ADDR_EXT0_OUT,			/* Extension 0 Peripheral Memory Addresss External */
													/* Multiplexed: */
													/* 	Extension 0 Peripheral Memory Addresss */
													/* 	Extension 0 Memory Address Monitor */
	output 			BYTE,						/* Flash Byte Mode */
	output [1:0]	BYTES_EXT0_OUT,		/* */
	output 			BYTESEL,					/* Flash Byte Select */
	output			EXTCLK_EN_EXT0e,	/* */
	output 			CE_FLASH,				/* Flash Chip Enable */
	output 			EMPTY_RG_EXT0e,		/* Extension 0 Register Write Buffer Empty External */
	output 			EN_EXT0e,				/* Extension 0 Enable External */
	output 			ENEXT_EXT0e,			/* Extension 0 Execution Enable External */
	output 			EXCEXT_EXT0e,			/* Extension 0 Exception Flush External */
	output 			EXTNOP_EX_EXT0e,		/* Extension 0 Extension Bubble in Execute Phase External */
	output 			EXTNOP_MA_EXT0e,		/* Extension 0 Extension Bubble in Memory Access Phase External */
	output 			FULL_RG_EXT0e,			/* Extension 0 Register Write Buffer Full External */
	output [31:0]	GPIO_IN,					/* GPIO data in to tristate buffer out to pins */
	output [31:0]	GPIO_TR,					/* GPIO data pin direction */
	output			GR_EXT0e,				/* Extension 0 Grant Pipeline Resources External */
	output [31:0]	INSTR_EXT0e,			/* Extension 0 Current Instruction External */
	output			LDEXT_EXT0e,				/* Extension 0 Extension Loaded External */
	output [23:0]	MADDR_OUT,				/* Memory Address Bus (SRAM & Flash) */
	output [31:0]	MDATA_EXT0_OUT,		/* Extension 0 Memory Data In External */
													/* Multiplexed: */
													/* 	Extension 0 Memory Data In */
													/* 	Extension 0 Peripheral Memory Data In */
													/* 	Extension 0 Memory Data Monitor */
	output [31:0]	MDATA_IN,				/* Memory data bus in to tristate buffer out to pins */
	output [31:0]	MDATA_TR,				/* Memory data pin direction */
	output [3:0]	MDATAP_IN,				/* Memory data parity bus in to tristate buffer out to pins */
	output [3:0]	MDATAP_TR,				/* Memory data parity pin direction */
	output			MDATAVLD_EXT0_OUT,	/* Extension 0 Memory Data Valid External */
													/* Multiplexed: */
													/* 	Extension 0 Memory Data Valid */
													/* 	Extension 0 Memory Data Valid Monitor */
	output			MODE,						/* SRAM Mode */
	output			NADVLD,					/* SRAM ADV/LD */
	output [3:0]	NBW,						/* SRAM Byte Write Enable */
	output			NCE_SRAM,				/* SRAM Chip Enable */
	output			NCE_SYSACE,				/* System Ace Chip Enable */
	output			NOE_MEM,					/* Memory Output Enable (SRAM & Flash) */
	output			NOE_PER,					/* Peripheral Output Enable (SYSACE) */
	output			NRP,						/* Flash Hardware Reset */
	output			NWE_MEM,					/* Memory Write Enable (SRAM & Flash) */
	output			NWE_PER,					/* Peripheral Write Enable (SYSACE) */
	output			OE_EXT0_OUT,			/* Extension 0 Peripheral Output Enable External */
													/* Multiplexed: */
													/* 	Extension 0 Peripheral Output Enable */
													/* 	Extension 0 Memory Output Enable Monitor */
	output [6:0]	PADDR_OUT,				/* Peripheral Address Bus (SYSACE) */
	output [31:0]	PC_EXT0e,				/* Extension 0 Current PC External */
	output 			PCLK_EXT0e,				/* Extension 0 Pipeline Clock External */
	output [15:0]	PDATA_IN,				/* Peripheral data bus in to tristate buffer out to pins */
	output [15:0]	PDATA_TR,				/* Peripheral data pin direction */
	output			PER0_BAT_EN_OUT,		/* */
	output			PER0_MSRT_OUT,	/* */
	output [31:0]	RDREG1DATA_EXT0e,		/* Extension 0 Register Read Port 1 Register Data External */
	output [31:0]	RDREG2DATA_EXT0e,		/* Extension 0 Register Read Port 2 Register Data External */
	output [31:0]	RDREG3DATA_EXT0e,		/* Extension 0 Register Read Port 3 Register Data External */
	output [31:0]	RDREG4DATA_EXT0e,		/* Extension 0 Register Read Port 4 Register Data External */
	output			REGRDY_EXT0e,			/* Extension 0 Register Write Buffer Ready External */
	output			REGWRITE1_RG_EXT0e,	/* Extension 0 Register Write Port 1 Write Enable Monitor External */
	output			REGWRITE2_RG_EXT0e,	/* Extension 0 Register Write Port 2 Write Enable Monitor External */
	output			RESET_EXT0e,			/* Extension 0 System Reset External */
	output			SCLK,						/* Baud Clock */
	output			TX,						/* System Serial Transmit */
	output			WE_EXT0_OUT,			/* Extension 0 Peripheral Write Enable External */
													/* Multiplexed: */
													/* 	Extension 0 Peripheral Write Enable */
													/* 	Extension 0 Memory Write Enable Monitor */
	output [31:0]	WRDATA1_RG_EXT0e,		/* Extension 0 Register Write Port 1 Data Monitor External */
	output [31:0]	WRDATA2_RG_EXT0e,		/* Extension 0 Register Write Port 2 Data Monitor External */
	output [4:0]	WRREG1_RG_EXT0e,		/* Extension 0 Register Write Port 1 Register Number Monitor External */
	output [4:0]	WRREG2_RG_EXT0e,		/* Extension 0 Register Write Port 2 Register Number Monitor External */
	output			ZZ,
	/* INOUT PORTS */
	inout				CLK_EXT					/* External Clock */
	);

endmodule
