/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	adder																*/
/* Module Names:	adder32															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module adder32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	A,			/* Operand 1 */
	input [31:0]	B,			/* Operand 2 */
	input 			C_IN,		/* Carry-in */
	/* OUTPUT PORTS */
	output 			C_OUT,	/* Carry-out */
	output [31:0]	C			/* Result */
	);

/*********************************************************************/
	
	assign {C_OUT,C}	=	A + B + C_IN;

endmodule
