/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	address_translation											*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module address_translation(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input 			BLS,		/* Byte Load/Store */
	input 			HLS,		/* Halfword Load/Store */
	input 			MEMREAD,	/* Memory Read */
	input [31:0]	VADDR,	/* Virtual Address */
	/* OUTPUT PORTS */
	output [31:0]	PADDR		/* Physical Address */
	);

/*********************************************************************/
	
	assign PADDR[1:0]		=	(MEMREAD == 1'b1)?	2'b00:
									(BLS == 1'b1)?			VADDR[1:0]:
									(HLS == 1'b1)?			{VADDR[1],1'b0}:
																2'b00;
	assign PADDR[27:2]	=	VADDR[27:2];
	assign PADDR[31:28]	=	(VADDR[31:28] == 4'b1000)?	4'b0:
									(VADDR[31:28] == 4'b1001)?	4'b1:
									(VADDR[31:28] == 4'b1010)?	4'b0:
									(VADDR[31:28] == 4'b1011)?	4'b1:
																		VADDR[31:28];

endmodule
