/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	and																*/
/* Module Names:	and2_1															*/
/*						and2_2															*/
/*						and2_5															*/
/*						and2_8															*/
/*						and2_32															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module and2_1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input		A,	/* Input A */
	input		B,	/* Input B */
	/* OUTPUT PORTS */
	output	C	/* Result */
	);

/*********************************************************************/
	
	assign C	=	A & B;
	
endmodule

module and2_2(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [1:0]		A,	/* Input A */
	input [1:0]		B,	/* Input B */
	/* OUTPUT PORTS */
	output [1:0]	C	/* Result */
	);

/*********************************************************************/
	
	assign C	=	A & B;
	
endmodule

module and2_5(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [4:0] 	A,	/* Input A */
	input [4:0]		B,	/* Input B */
	/* OUTPUT PORTS */
	output [4:0]	C	/* Result */
	);

/*********************************************************************/
	
	assign C	=	A & B;

endmodule

module and2_8(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [7:0] 	A,	/* Input A */
	input [7:0]		B,	/* Input B */
	/* OUTPUT PORTS */
	output [7:0]	C	/* Result */
	);

/*********************************************************************/
	
	assign C	=	A & B;
	
endmodule

module and2_32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	A,	/* Input A */
	input [31:0]	B,	/* Input B */
	/* OUTPUT PORTS */
	output [31:0]	C	/* Result */
	);

/*********************************************************************/

	assign C	=	A & B;
	
endmodule
