/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	BSMUX																*/
/* Module Names:	BSMUX1_2to1														*/
/*						BSMUX4_2to1														*/
/*						BSMUX24_2to1													*/
/*						BSMUX32_2to1													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module BSMUX1_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input		a0,		/* Input 0 */
	input		a1,		/* Input 1 */
	input		def,		/* Default Value */
	input		en0,		/* Enable 0 */
	input		en1,		/* Enable 1 */
	/* OUTPUT PORTS */
	output	out		/* Output */
	);

/*********************************************************************/

	assign out =	(en0)?	a0:
						(en1)?	a1:
									def;
									
endmodule

module BSMUX4_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input	[3:0]	a0,		/* Input 0 */
	input [3:0] a1,		/* Input 1 */
	input [3:0] def,		/* Default Value */
	input 		en0,		/* Enable 0 */
	input			en1,		/* Enable 1 */
	/* OUTPUT PORTS */
	output [3:0] out		/* Output */
	);

/*********************************************************************/
	
	assign out =	(en0)?	a0:
						(en1)?	a1:
									def;

endmodule

module BSMUX24_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [23:0]	a0,		/* Input 0 */
	input [23:0]	a1,		/* Input 1 */
	input [23:0]	def,		/* Default Value */
	input				en0,		/* Enable 0 */
	input				en1,		/* Enable 1 */
	/* OUTPUT PORTS */
	output [23:0]	out		/* Output */
	);

/*********************************************************************/
	
	assign out =	(en0)?	a0:
						(en1)?	a1:
									def;

endmodule

module BSMUX32_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,		/* Input 0 */
	input [31:0]	a1,		/* Input 1 */
	input [31:0]	def,		/* Default Value */
	input				en0,		/* Enable 0 */
	input				en1,		/* Enable 1 */
	/* OUTPUT PORTS */
	output [31:0]	out		/* Output */
	);
	
/*********************************************************************/

	assign out =	(en0)?	a0:
						(en1)?	a1:
									def;
									
endmodule
