/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	bytesel2															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module bytesel2(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [1:0]		ADDR,		/* Least significant bits of address bus */
	input [1:0]		BYTES,	/* Number of bytes to be written */
	/* OUTPUT PORTS */
	output [3:0]	BW			/* Byte Selects */
	);

/*****Signals****************************************************************/
	
	wire [3:0] BW0;	/* Byte Selects for number of bytes */
	wire [3:0] BW1;	/* Byte Selects shifted for address */

/*********************************************************************/

	assign BW0 =	(BYTES == 2'b00)?	4'b1111:
						(BYTES == 2'b11)?	4'b0111:
						(BYTES == 2'b10)? 4'b0011:
						(BYTES == 2'b01)? 4'b0001:
												4'b0000;
	assign BW1 =	(ADDR == 2'b00)?	{BW0}:
						(ADDR == 2'b01)?	{BW0[2:0],1'b0}:
						(ADDR == 2'b10)?	{BW0[1:0],2'b0}:
						(ADDR == 2'b11)?	{BW0[0],3'b0}:
												{4'b0};
	assign BW = 	~BW1;
	
endmodule
