/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	data_align														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module data_align(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [1:0]		ADDR,		/* Least significant bits of address bus */
	input [31:0]	DATA_IN,	/* Incoming Data */
	/* OUTPUT PORTS */
	output [31:0]	DATA_OUT	/* Address Aligned Incoming Data */
	);

/*********************************************************************/
	
	assign DATA_OUT = (ADDR == 2'b00)?	(DATA_IN):
							(ADDR == 2'b01)?	(DATA_IN<<8):
							(ADDR == 2'b10)?	(DATA_IN<<16):
							(ADDR == 2'b11)?	(DATA_IN<<24):
													32'b0;

endmodule
