/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	endianflip32													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module endianflip32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input EN,				/* Enable */
	input [31:0] IN,		/* Input */
	/* OUTPUT PORTS */
	output [31:0] OUT		/* Output */
	);

/*********************************************************************/

	assign OUT[31:24]	=	(EN == 1'b1)?	IN[7:0]:		IN[31:24];
	assign OUT[23:16]	=	(EN == 1'b1)?	IN[15:8]:	IN[23:16];
	assign OUT[15:8]	=	(EN == 1'b1)?	IN[23:16]:	IN[15:8];
	assign OUT[7:0]	=	(EN == 1'b1)?	IN[31:24]:	IN[7:0];

endmodule
