/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	fifo																*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module fifo(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [83:0]	din,		/* Data In */
	input				rd_clk,	/* Read Clock */
	input				rd_en,	/* Read Enable */
	input				rst,		/* Reset */
	input				wr_clk,	/* Write Clock */
	input				wr_en,	/* Write Enable */
	/* OUTPUT PORTS */
	output [41:0]	dout,		/* Data Out */
	output			empty,	/* FIFO Empty */
	output			full		/* FIFO Full */
	);

/*********************************************************************/
	
	wrregfifo_fg wrbuf(
		.din(din),
		.dout(dout),
		.empty(empty),
		.full(full),
		.rd_clk(rd_clk),
		.rd_en(rd_en),
		.rst(rst),
		.wr_clk(wr_clk),
		.wr_en(wr_en)
		);

endmodule
