/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	fifo_ICE															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module fifo(din,rd_clk,rd_en,rst,wr_clk,wr_en,dout,empty,full);
	input rd_clk, rd_en, rst, wr_clk, wr_en;
	input [83:0] din;
	output empty, full;
	output [41:0] dout;

	/*wrregfifo_fg wrbuf(
		.din(din),
		.rd_clk(rd_clk),
		.rd_en(rd_en),
		.rst(rst),
		.wr_clk(wr_clk),
		.wr_en(wr_en),
		.dout(dout),
		.empty(empty),
		.full(full)
		);*/

	reg [41:0] buffer [0:31];
	reg [3:0] wrindex;
	reg [4:0] rdindex;
	
	wire [3:0] diffindex;
	
	integer i;
	
	assign diffindex = rdindex[4:1] - wrindex;
	assign full = (diffindex == 1);
	assign empty = (diffindex == 0) & (rdindex[0]);
	assign dout = buffer[rdindex];
	
	always@(posedge rd_clk)
	begin
		if (rst)
		begin
			rdindex <= 5'hff;
		end
		else
		begin
			if (~empty)
			begin
				if (rd_en)
				begin	
					rdindex <= rdindex + 1;
				end
			end
			else
			begin
			end
		end
	end
	
	always@(posedge wr_clk)
	begin
		if (rst)	
		begin
			for (i=0; i<32; i=i+1)
			begin
				buffer[i] <= 0;
			end
			wrindex <= 4'hff;
		end
		else
		begin
			if (~full)
			begin
				if (wr_en)
				begin
					wrindex <= wrindex + 1;
					buffer[{wrindex,1'b0}] <= din[83:42];
					buffer[{wrindex,1'b1}] <= din[41:0];
				end
			end
		end
	end
	
endmodule
