/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	greaterthan														*/
/* Module Names:	greater2_32														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual		*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module greater2_32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	IN1,	/* Input 1 */
	input [31:0]	IN2,	/* Input 2 */
	input				US,	/* Signed/Unsigned */
	/* OUTPUT PORTS */
	output			GTT	/* Restult */
	);

/*********************************************************************/

	assign GTT	= 	(US == 1'b1)?										(IN1 > IN2):
						((IN1[31] == 1'b1) && (IN2[31] == 1'b0))?	1'b0:
						((IN1[31] == 1'b0) && (IN2[31] == 1'b1))?	1'b1:
						((IN1[31] == 1'b0) && (IN2[31] == 1'b0))?	(IN1[30:0] > IN2[30:0]):
						((IN1[31] == 1'b1) && (IN2[31] == 1'b1))?	(IN2[30:0] > IN1[30:0]):
																				1'b0;
																				
endmodule
