/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	lock																*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	1.1	-	Extension Peripherals									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module lock(
	input CLK,
	input CLK_EN,
	input LD_EXT,
	input RESET,
	input PRESENT_K,
	output PRESENT_LK
	);

	wire match;

	reg 			present_reg;
	reg [27:0]	lockreg;
	reg [1:0]	state;
	
	parameter KEYPHRASE	=	14'b00111000011111;
	
	initial
	begin
		lockreg = 28'hfffffff;
		present_reg = 1'b0;
		state = 2'b0;
	end
	
	assign match = (lockreg == {KEYPHRASE,KEYPHRASE});
	assign PRESENT_LK = present_reg;
	
	always@(posedge CLK)
	begin
		if (~RESET)
		begin
			lockreg <= 28'hfffffff;
			present_reg <= 1'b0;
			state <= 2'b0;
		end
		else
		begin
			case(state)
				2'b00		:	begin
									if (CLK_EN)
									begin
										state <= 2'b01;
										//$stop;
									end
									lockreg <= 28'hfffffff;
									present_reg <= 1'b0;
								end
				2'b01		:	begin
									if (match)
									begin
										state <= 2'b10;
										//$stop;
									end
									else
									begin
										lockreg <= {lockreg[26:0],PRESENT_K};
										present_reg <= 1'b0;
									end
									if (~CLK_EN)
									begin
										state <= 2'b00;
										//$stop;
									end
								end
				2'b10		:	begin
									if (LD_EXT)
									begin
										state <= 2'b11;
										//$stop;
									end
									if (~CLK_EN)
									begin
										state <= 2'b00;
										//$stop;
									end
									present_reg <= 1'b1;
								end
				2'b11		:	begin
									if (~PRESENT_K & ~match)
									begin
										state <= 2'b00;
										//$stop;
									end
									if (~LD_EXT)
									begin
										state <= 2'b01;
										//$stop;
									end
									if (~CLK_EN)
									begin
										state <= 2'b00;
										//$stop;
									end
									lockreg <= 28'hfffffff;
									present_reg <= 1'b1;
								end
				default	:	begin
									state <= 2'b00;
								end
			endcase
		end
	end
	
endmodule
