/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Nathaniel Lee Lynch												*/
/*					Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	mux																*/
/* Module Names:	MUX1_8to1														*/
/*						MUX1_4to1														*/
/*						MUX1_2to1														*/
/*						MUX5_2to1														*/
/*						MUX8_2to1														*/
/*						MUX8_4to1														*/
/*						MUX16_2to1														*/
/*						MUX32_2to1														*/
/*						MUX32_4to1														*/
/*						MUX32_8to1														*/
/*						MUX32_1to1LL													*/
/*						MUX32_1to1RL													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module MUX1_8to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input			a0,	/* Input 0 */
	input			a1,	/* Input 1 */
	input			a2,	/* Input 2 */
	input			a3,	/* Input 3 */
	input			a4,	/* Input 4 */
	input			a5,	/* Input 5 */
	input			a6,	/* Input 6 */
	input			a7,	/* Input 7 */
	input [2:0]	sel,	/* Switch */
	/* OUTPUT PORTS */
	output		out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 3'b000)?	a0:
						(sel == 3'b001)?	a1:
						(sel == 3'b010)?	a2:
						(sel == 3'b011)?	a3:
						(sel == 3'b100)?	a4:
						(sel == 3'b101)?	a5:
						(sel == 3'b110)?	a6:
												a7;

endmodule

module MUX1_4to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input			a0,	/* Input 0 */
	input			a1,	/* Input 1 */
	input			a2,	/* Input 2 */
	input			a3,	/* Input 3 */
	input [1:0]	sel,	/* Switch */
	/* OUTPUT PORTS */
	output		out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 2'b00)?	a0:
						(sel == 2'b01)?	a1:
						(sel == 2'b10)?	a2:
												a3;

endmodule

module MUX1_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input		a0,	/* Input 0 */
	input		a1,	/* Input 1 */
	input		sel,	/* Switch */
	/* OUTPUT PORTS */
	output	out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 1'b0)?	a0:
											a1;

endmodule

module MUX5_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [4:0]		a0,	/* Input 0 */
	input [4:0]		a1,	/* Input 1 */
	input 			sel,	/* Switch */
	/* OUTPUT PORTS */
	output [4:0]	out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 1'b0)?	a0:
											a1;

endmodule

module MUX5_4to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [4:0]		a0,	/* Input 0 */
	input [4:0]		a1,	/* Input 1 */
	input [4:0]		a2,	/* Input 2 */
	input [4:0]		a3,	/* Input 3 */
	input [1:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [4:0]	out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 2'b00)?	a0:
						(sel == 2'b01)?	a1:
						(sel == 2'b10)?	a2:
												a3;

endmodule 

module MUX8_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [7:0]		a0,	/* Input 0 */
	input [7:0]		a1,	/* Input 1 */
	input				sel,	/* Switch */
	/* OUTPUT PORTS */
	output [7:0]	out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 1'b0)?	a0:
											a1;

endmodule 

module MUX8_4to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [7:0]		a0,	/* Input 0 */
	input [7:0]		a1,	/* Input 1 */
	input [7:0]		a2,	/* Input 2 */
	input [7:0]		a3,	/* Input 3 */
	input [1:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [7:0]	out	/* Output */
	);

/*********************************************************************/

	assign out	=	(sel == 2'b00)?	a0:
						(sel == 2'b01)?	a1:
						(sel == 2'b10)?	a2:
												a3;                  

endmodule 

module MUX16_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [15:0]	a0,	/* Input 0 */
	input [15:0]	a1,	/* Input 1 */
	input				sel,	/* Switch */
	/* OUTPUT PORTS */
	output [15:0]	out	/* Output */
	);

/*********************************************************************/

	assign out	=	(sel == 1'b0)?	a0:
											a1;

endmodule 

module MUX32_2to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,	/* Input 0 */
	input [31:0]	a1,	/* Input 1 */
	input				sel,	/* Switch */
	/* OUTPUT PORTS */
	output [31:0]	out	/* Output */
	);

/*********************************************************************/
	
	assign out	=	(sel == 1'b0)?	a0:
											a1;

endmodule 

module MUX32_4to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,	/* Input 0 */
	input [31:0]	a1,	/* Input 1 */
	input [31:0]	a2,	/* Input 2 */
	input [31:0]	a3,	/* Input 3 */
	input [1:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [31:0]	out	/* Output */
	);

/*********************************************************************/

	assign out	=	(sel == 2'b00)?	a0:
						(sel == 2'b01)?	a1:
						(sel == 2'b10)?	a2:
												a3;

endmodule 

module MUX32_8to1(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,	/* Input 0 */
	input [31:0]	a1,	/* Input 1 */
	input [31:0]	a2,	/* Input 2 */
	input [31:0]	a3,	/* Input 3 */
	input [31:0]	a4,	/* Input 4 */
	input [31:0]	a5,	/* Input 5 */
	input [31:0]	a6,	/* Input 6 */
	input [31:0]	a7,	/* Input 7 */
	input [2:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [31:0]	out 	/* Output */
	);

/*****Signals****************************************************************/
	
	wire [31:0]	outA;	/* Output of Mux A */
	wire [31:0]	outB;	/* Output of Mux B */

/*********************************************************************/

	MUX32_4to1 A(
		.a0(a0),
		.a1(a1),
		.a2(a2),
		.a3(a3),
		.sel(sel[1:0]),
		.out(outA))
		;
		
	MUX32_4to1 B(
		.a0(a4),
		.a1(a5),
		.a2(a6),
		.a3(a7),
		.sel(sel[1:0]),
		.out(outB)
		);

	assign out	=	(sel[2] == 1'b0)?	outA:
												outB;

endmodule

module MUX32_1to1LL(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,	/* Input */
	input [1:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [31:0]	out	/* Output */
	);

/*********************************************************************/

	MUX8_4to1 mux0(
		.a0(a0[7:0]), 
		.a1(a0[15:8]), 
		.a2(a0[23:16]),
		.a3(a0[31:24]), 
		.sel(sel), 
		.out(out[31:24])
		);

	MUX8_4to1 mux3(
		.a0(8'b0), 
		.a1(a0[7:0]), 
		.a2(a0[15:8]),
		.a3(a0[23:16]),
		.sel(sel),
		.out(out[23:16])
		);
	
	MUX8_4to1 mux6(
		.a0(8'b0), 
		.a1(8'b0), 
		.a2(a0[7:0]), 
		.a3(a0[15:8]),
		.sel(sel), 
		.out(out[15:8])
		);

	MUX8_4to1 mux9(
		.a0(8'b0), 
		.a1(8'b0), 
		.a2(8'b0),
		.a3(a0[7:0]), 
		.sel(sel),
		.out(out[7:0])
		);

endmodule

module MUX32_1to1RL(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	a0,	/* Input */
	input [1:0]		sel,	/* Switch */
	/* OUTPUT PORTS */
	output [31:0]	out	/* Output */
	);

/*********************************************************************/
	
	MUX8_4to1 mux0(
		.a0(a0[31:24]), 
		.a1(8'b0), 
		.a2(8'b0),
		.a3(8'b0), 
		.sel(sel), 
		.out(out[31:24])
		);

	MUX8_4to1 mux3(
		.a0(a0[23:16]), 
		.a1(a0[31:24]), 
		.a2(8'b0),
		.a3(8'b0),
		.sel(sel),
		.out(out[23:16])
		);
	
	MUX8_4to1 mux6(
		.a0(a0[15:8]), 
		.a1(a0[23:16]), 
		.a2(a0[31:24]), 
		.a3(8'b0),
		.sel(sel), 
		.out(out[15:8])
		);

	MUX8_4to1 mux9(
		.a0(a0[7:0]), 
		.a1(a0[15:8]), 
		.a2(a0[23:16]),
		.a3(a0[31:24]), 
		.sel(sel),
		.out(out[7:0])
		);

endmodule
