/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	registerblock													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module registerblock(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [4:0]		addra,	/* Port A Address */
	input [4:0]		addrb,	/* Port B Address */
	input				clka,		/* Port A Clock */
	input				clkb,		/* Port B Clock */
	input [31:0]	dinb,		/* Port B Data In */
	input				rst,		/* Reset */
	input				web,		/* Port B Write Enable */
	/* OUTPUT PORTS */
	output [31:0]	douta,	/* Port A Data Out */
	output [31:0]	doutb,		/* Port B Data Out */
	/* DEBUG PORTS */
	output [31:0] regfile00,
	output [31:0] regfile01,
	output [31:0] regfile02,
	output [31:0] regfile03,
	output [31:0] regfile04,
	output [31:0] regfile05,
	output [31:0] regfile06,
	output [31:0] regfile07,
	output [31:0] regfile08,
	output [31:0] regfile09,
	output [31:0] regfile10,
	output [31:0] regfile11,
	output [31:0] regfile12,
	output [31:0] regfile13,
	output [31:0] regfile14,
	output [31:0] regfile15,
	output [31:0] regfile16,
	output [31:0] regfile17,
	output [31:0] regfile18,
	output [31:0] regfile19,
	output [31:0] regfile20,
	output [31:0] regfile21,
	output [31:0] regfile22,
	output [31:0] regfile23,
	output [31:0] regfile24,
	output [31:0] regfile25,
	output [31:0] regfile26,
	output [31:0] regfile27,
	output [31:0] regfile28,
	output [31:0] regfile29,
	output [31:0] regfile30,
	output [31:0] regfile31
	);

/*********************************************************************/
	
	regfileblock rf(
		.addra(addra),
		.addrb(addrb),
		.clka(clka),
		.clkb(clkb),
		.dinb(dinb),
		.douta(douta),
		.doutb(doutb),
		.sinita(rst),
		.sinitb(rst),
		.web(web)
		);

endmodule
